/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.runtime.BaseProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IOUtils;

class DBeaverSettingsImporter {
    private static final String[] COPY_PLUGINS = new String[]{"org.eclipse.compare", "org.eclipse.core.resources", "org.eclipse.core.runtime", "org.eclipse.e4.ui.workbench.swt", "org.eclipse.equinox.p2.ui", "org.eclipse.equinox.security.ui", "org.eclipse.help.ui", "org.eclipse.search", "org.eclipse.ui.ide", "org.eclipse.ui.views.log", "org.eclipse.ui.workbench", "org.eclipse.ui.workbench.texteditor"};
    private final DBeaverApplication application;
    private final Display display;
    private Shell windowShell;
    private Label progressLabel;
    private ProgressBar progressBar;
    private File oldDriversFolder;
    private File driversFolder;
    private File oldWorkspacePath;
    private int shellResult = 0;

    public DBeaverSettingsImporter(DBeaverApplication application, Display display) {
        this.application = application;
        this.display = display;
    }

    boolean migrateFromPreviousVersion(final File oldDir, final File newDir) {
        String oldVersion;
        Properties workspaceProps = new Properties();
        File versionFile = GeneralUtils.getMetadataFolder((Path)oldDir.toPath()).resolve("dbeaver-workspace.properties").toFile();
        if (versionFile.exists()) {
            try (FileInputStream is = new FileInputStream(versionFile);){
                workspaceProps.load(is);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        oldVersion = (oldVersion = workspaceProps.getProperty("product-version")) == null ? "3.x" : GeneralUtils.getPlainVersion((String)oldVersion);
        this.oldWorkspacePath = oldDir;
        this.oldDriversFolder = new File(System.getProperty("user.home"), ".dbeaver-drivers");
        this.driversFolder = new File(newDir.getParent(), "drivers");
        Image dbeaverIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.ui.app.standalone", (String)"icons/dbeaver32.png").createImage();
        Image dbeaverLogo = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.ui.app.standalone", (String)"icons/dbeaver64.png").createImage();
        WorkbenchPlugin.unsetSplashShell((Display)this.display);
        this.windowShell = new Shell(this.display);
        this.windowShell.setImage(dbeaverIcon);
        this.windowShell.setText("Import " + GeneralUtils.getProductName() + " configuration");
        this.windowShell.setLayout((Layout)new GridLayout(1, false));
        Group infoGroup = new Group((Composite)this.windowShell, 0);
        infoGroup.setText("Import workspace");
        infoGroup.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        infoGroup.setLayout((Layout)gl);
        Label iconLabel = new Label((Composite)infoGroup, 0);
        iconLabel.setImage(dbeaverLogo);
        iconLabel.setLayoutData((Object)new GridData(2));
        Label confirmLabel = new Label((Composite)infoGroup, 0);
        confirmLabel.setText("\n" + GeneralUtils.getProductTitle() + " uses a new configuration format.\n\nDo you want to migrate existing settings (version " + oldVersion + ")?\n\n");
        confirmLabel.setLayoutData((Object)new GridData(1808));
        Composite buttonsPanel = new Composite((Composite)this.windowShell, 0);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        buttonsPanel.setLayout((Layout)new GridLayout(2, true));
        final Button migrateButton = new Button(buttonsPanel, 8);
        migrateButton.setText("Migrate (Recommended)");
        final Button skipButton = new Button(buttonsPanel, 8);
        skipButton.setText("Do not migrate");
        migrateButton.setLayoutData((Object)new GridData(768));
        migrateButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DBeaverSettingsImporter this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                migrateButton.setEnabled(false);
                skipButton.setEnabled(false);
                this.this$0.progressBar.setVisible(true);
                ((GridData)this.this$0.progressBar.getLayoutData()).exclude = false;
                this.this$0.windowShell.pack();
                this.this$0.migrateWorkspace(oldDir, newDir);
            }
        });
        this.windowShell.setDefaultButton(migrateButton);
        skipButton.setLayoutData((Object)new GridData(768));
        skipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(DBeaverSettingsImporter.this.windowShell, 200);
                messageBox.setText("Skip workspace migration");
                messageBox.setMessage("You will lose all previous configurations and scripts.\n\nAre you sure?");
                int response = messageBox.open();
                if (response == 64) {
                    DBeaverSettingsImporter.this.shellResult = 2048;
                    DBeaverSettingsImporter.this.windowShell.dispose();
                }
            }
        });
        this.progressLabel = new Label((Composite)this.windowShell, 0);
        this.progressLabel.setLayoutData((Object)new GridData(1808));
        this.progressBar = new ProgressBar((Composite)this.windowShell, 65536);
        this.progressBar.setVisible(false);
        GridData gd = new GridData(1808);
        gd.heightHint = 30;
        gd.widthHint = 300;
        gd.exclude = true;
        this.progressBar.setLayoutData((Object)gd);
        this.windowShell.pack();
        Rectangle screenSize = this.display.getPrimaryMonitor().getBounds();
        this.windowShell.setLocation((screenSize.width - this.windowShell.getBounds().width) / 2, (screenSize.height - this.windowShell.getBounds().height) / 2);
        this.windowShell.open();
        while (!this.windowShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.shellResult != 0;
    }

    private void migrateWorkspace(File oldDir, File newDir) {
        this.progressLabel.setText("Counting workspace files...");
        long totalFiles = this.countWorkspaceFiles(oldDir);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum((int)((totalFiles += this.countWorkspaceFiles(this.oldDriversFolder)) / 1000L));
        BaseProgressMonitor monitor = new BaseProgressMonitor(){
            long bytesProcessed = 0L;

            public void subTask(@NotNull String name) {
                DBeaverSettingsImporter.this.display.syncExec(() -> DBeaverSettingsImporter.this.progressLabel.setText(name));
            }

            public void worked(int work) {
                DBeaverSettingsImporter.this.display.syncExec(() -> {
                    this.bytesProcessed += (long)work;
                    DBeaverSettingsImporter.this.progressBar.setSelection((int)(this.bytesProcessed / 1000L));
                });
            }
        };
        new Thread(() -> this.lambda$migrateWorkspace$0(newDir, (DBRProgressMonitor)monitor, oldDir)).start();
    }

    private long countWorkspaceFiles(File dir) {
        long count = 1L;
        File[] files = dir.listFiles();
        if (files == null) {
            return count;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                count += this.countWorkspaceFiles(file);
                continue;
            }
            count += file.length();
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private void copyWorkspaceFiles(DBRProgressMonitor monitor, DIR_TYPE parentDirType, File fromDir, File toDir) {
        files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        skippedFiles = 0L;
        block46: for (File file : files) {
            block60: {
                block62: {
                    dirType = DIR_TYPE.NORMAL;
                    var14_13 = fileName = file.getName();
                    var15_14 = -1;
                    switch (var14_13.hashCode()) {
                        case -1988530851: {
                            if (!var14_13.equals(".metadata")) break;
                            var15_14 = 0;
                            break;
                        }
                        case -1910732878: {
                            if (!var14_13.equals(".plugins")) break;
                            var15_14 = 1;
                            break;
                        }
                        case 2089097844: {
                            if (!var14_13.equals("org.jkiss.dbeaver.core")) break;
                            var15_14 = 2;
                        }
                    }
                    switch (var15_14) {
                        case 0: {
                            if (parentDirType != DIR_TYPE.WORKSPACE) break;
                            dirType = DIR_TYPE.METADATA;
                            break;
                        }
                        case 1: {
                            if (parentDirType != DIR_TYPE.METADATA) break;
                            dirType = DIR_TYPE.PLUGINS;
                            break;
                        }
                        case 2: {
                            if (parentDirType != DIR_TYPE.PLUGINS) break;
                            dirType = DIR_TYPE.CORE;
                        }
                    }
                    relPath = file.getAbsolutePath().substring(this.oldWorkspacePath.getAbsolutePath().length());
                    monitor.subTask(relPath);
                    if (!file.isDirectory()) break block62;
                    if (!(parentDirType != DIR_TYPE.METADATA || fileName.equals(".plugins") || fileName.equals("qmdb") || fileName.startsWith("dbeaver"))) {
                        skippedFiles += this.countWorkspaceFiles(file);
                        continue;
                    }
                    if (parentDirType == DIR_TYPE.PLUGINS && !fileName.contains("dbeaver") && !ArrayUtils.contains((Object[])DBeaverSettingsImporter.COPY_PLUGINS, (Object)fileName)) {
                        skippedFiles += this.countWorkspaceFiles(file);
                        continue;
                    }
                    if (parentDirType != DIR_TYPE.CORE) ** GOTO lbl-1000
                    var15_15 = fileName;
                    var16_17 = -1;
                    switch (var15_15.hashCode()) {
                        case 1920363851: {
                            if (!var15_15.equals("drivers")) break;
                            var16_17 = 0;
                            break;
                        }
                        case 103670155: {
                            if (!var15_15.equals("maven")) break;
                            var16_17 = 1;
                            break;
                        }
                        case -934610874: {
                            if (!var15_15.equals("remote")) break;
                            var16_17 = 2;
                        }
                    }
                    switch (var16_17) {
                        case 0: 
                        case 1: 
                        case 2: {
                            targetDir = new File(this.driversFolder, fileName);
                            if (!targetDir.exists() && !targetDir.mkdirs()) {
                                System.err.println("Can't create drivers folder " + targetDir.getAbsolutePath());
                                skippedFiles += this.countWorkspaceFiles(file);
                                continue block46;
                            }
                            this.copyWorkspaceFiles(monitor, DIR_TYPE.NORMAL, file, targetDir);
                            continue block46;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if ((newDir = new File(toDir, fileName)).exists() || newDir.mkdir()) {
                                this.copyWorkspaceFiles(monitor, dirType, file, newDir);
                                break;
                            }
                            System.err.println("Can't create folder " + newDir.getAbsolutePath());
                            break;
                        }
                    }
                    break block60;
                }
                if (parentDirType == DIR_TYPE.METADATA && fileName.startsWith(".")) {
                    ++skippedFiles;
                    continue;
                }
                newFile = new File(toDir, fileName);
                if (fileName.equals("org.jkiss.dbeaver.core.prefs")) {
                    coreProps = new Properties();
                    try {
                        is = new FileInputStream(file);
                        try {
                            coreProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                    driversHomeProp = coreProps.getProperty("ui.drivers.home");
                    if (driversHomeProp != null && !driversHomeProp.isEmpty() && (oldDriversPath = new File(driversHomeProp)).equals(new File(this.oldWorkspacePath, ".metadata/.plugins/org.jkiss.dbeaver.core"))) {
                        coreProps.setProperty("ui.drivers.home", this.driversFolder.getAbsolutePath());
                    }
                    try {
                        os = new FileOutputStream(newFile);
                        try {
                            coreProps.store(os, null);
                        }
                        finally {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                } else if (parentDirType == DIR_TYPE.CORE && fileName.equals("drivers.xml")) {
                    driversText = null;
                    try {
                        r = new InputStreamReader((InputStream)new FileInputStream(file), GeneralUtils.UTF8_CHARSET);
                        try {
                            driversText = IOUtils.readToString((Reader)r);
                            driversText = driversText.replace("${workspace}\\.metadata\\.plugins\\org.jkiss.dbeaver.core", "${drivers_home}");
                            driversText = driversText.replace("${workspace}/.metadata/.plugins/org.jkiss.dbeaver.core", "${drivers_home}");
                        }
                        finally {
                            r.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                    if (driversText != null) {
                        try {
                            w = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), GeneralUtils.UTF8_CHARSET);
                            try {
                                w.write(driversText);
                            }
                            finally {
                                w.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                } else {
                    this.copyFileContents(file, newFile);
                }
            }
            monitor.worked((int)(file.length() + skippedFiles));
        }
    }

    private void copyFolderFiles(DBRProgressMonitor monitor, File fromDir, File toDir) {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            monitor.subTask(file.getName());
            if (file.isDirectory()) {
                File newDir = new File(toDir, file.getName());
                if (newDir.exists() || newDir.mkdirs()) {
                    this.copyFolderFiles(monitor, file, newDir);
                    continue;
                }
                System.err.println("Can't create folder " + newDir.getAbsolutePath());
                continue;
            }
            this.copyFileContents(file, new File(toDir, file.getName()));
            monitor.worked((int)file.length());
        }
    }

    private void copyFileContents(File file, File newFile) {
        if (!newFile.exists() || newFile.length() != file.length()) {
            try (FileInputStream is = new FileInputStream(file);
                 FileOutputStream os = new FileOutputStream(newFile);){
                IOUtils.fastCopy((InputStream)is, (OutputStream)os, (int)100000);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private int showMessageBox(String title, String message, int style) {
        MessageBox messageBox = new MessageBox(this.windowShell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$migrateWorkspace$0(File newDir, DBRProgressMonitor monitor, File oldDir) {
        block3: {
            try {
                if (newDir.exists() || newDir.mkdirs()) break block3;
                System.err.println("Can't create target workspace directory '" + newDir.getAbsolutePath() + "'");
                DBeaverApplication.WORKSPACE_MIGRATED = true;
            }
            catch (Throwable throwable) {
                DBeaverApplication.WORKSPACE_MIGRATED = true;
                this.display.syncExec(new Runnable(){
                    final /* synthetic */ File val$newDir;
                    final /* synthetic */ DBeaverSettingsImporter this$0;
                    {
                        this.val$newDir = file;
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.showMessageBox("Import completed", "Configuration was imported to '" + this.val$newDir.getAbsolutePath() + "'", 34);
                        this.this$0.shellResult = 32;
                        this.this$0.windowShell.dispose();
                    }
                });
                throw throwable;
            }
            this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        this.copyWorkspaceFiles(monitor, DIR_TYPE.WORKSPACE, oldDir, newDir);
        this.copyFolderFiles(monitor, this.oldDriversFolder, this.driversFolder);
        DBeaverApplication.WORKSPACE_MIGRATED = true;
        this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
    }

    static enum DIR_TYPE {
        WORKSPACE,
        NORMAL,
        METADATA,
        PLUGINS,
        CORE;

    }
}

