/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeValue {
    @NotNull
    private final DBSAttributeBase attribute;
    @Nullable
    private final Object value;

    public DBDAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) {
        this.attribute = attribute;
        this.value = value;
    }

    @NotNull
    public DBSAttributeBase getAttribute() {
        return this.attribute;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.attribute.getName() + "=" + String.valueOf(this.value);
    }

    @NotNull
    public static DBSAttributeBase[] getAttributes(@NotNull DBDAttributeValue[] attrValues) {
        DBSAttributeBase[] attributes = new DBSAttributeBase[attrValues.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = attrValues[i].getAttribute();
        }
        return attributes;
    }

    @NotNull
    public static Object[] getValues(@NotNull DBDAttributeValue[] attrValues) {
        Object[] values = new Object[attrValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = attrValues[i].getValue();
        }
        return values;
    }

    public static DBSAttributeBase[] getAttributes(List<DBDAttributeValue> attrValues) {
        DBSAttributeBase[] attributes = new DBSAttributeBase[attrValues.size()];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = attrValues.get((int)i).attribute;
        }
        return attributes;
    }

    public static Object[] getValues(List<DBDAttributeValue> attrValues) {
        Object[] values = new Object[attrValues.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = attrValues.get((int)i).value;
        }
        return values;
    }

    public static DBDAttributeValue getAttributeValue(List<DBDAttributeValue> valueList, DBSEntityAttribute attribute) {
        for (DBDAttributeValue value : valueList) {
            if (!CommonUtils.equalObjects((Object)value.attribute.getName(), (Object)attribute.getName())) continue;
            return value;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DBDAttributeValue)) {
            return false;
        }
        if (!CommonUtils.equalObjects((Object)this.value, (Object)((DBDAttributeValue)obj).value)) {
            return false;
        }
        return CommonUtils.equalObjects((Object)this.attribute.getName(), (Object)((DBDAttributeValue)obj).attribute.getName());
    }
}

