/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractLivelinessMonitor<O>
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLivelinessMonitor.class);
    private Thread checkerThread;
    private volatile boolean stopped;
    public static final int DEFAULT_EXPIRE = 300000;
    private long expireInterval = 300000L;
    private long monitorInterval = this.expireInterval / 3L;
    private volatile boolean resetTimerOnStart = true;
    private final Clock clock;
    private Map<O, Long> running = new HashMap<O, Long>();

    public AbstractLivelinessMonitor(String name, Clock clock) {
        super(name);
        this.clock = clock;
    }

    public AbstractLivelinessMonitor(String name) {
        this(name, new MonotonicClock());
    }

    @Override
    protected void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        this.resetTimer();
        this.checkerThread = new Thread(new PingChecker());
        this.checkerThread.setName("Ping Checker for " + this.getName());
        this.checkerThread.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.checkerThread != null) {
            this.checkerThread.interrupt();
        }
        super.serviceStop();
    }

    protected abstract void expire(O var1);

    protected void setExpireInterval(long expireInterval) {
        this.expireInterval = expireInterval;
    }

    protected long getExpireInterval(O o) {
        return this.expireInterval;
    }

    protected void setMonitorInterval(long monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public synchronized void receivedPing(O ob) {
        if (this.running.containsKey(ob)) {
            this.running.put(ob, this.clock.getTime());
        }
    }

    public synchronized void register(O ob) {
        this.register(ob, this.clock.getTime());
    }

    public synchronized void register(O ob, long expireTime) {
        this.running.put(ob, expireTime);
    }

    public synchronized void unregister(O ob) {
        this.running.remove(ob);
    }

    public synchronized void resetTimer() {
        if (this.resetTimerOnStart) {
            long time = this.clock.getTime();
            for (O ob : this.running.keySet()) {
                this.running.put(ob, time);
            }
        }
    }

    protected void setResetTimeOnStart(boolean resetTimeOnStart) {
        this.resetTimerOnStart = resetTimeOnStart;
    }

    private class PingChecker
    implements Runnable {
        private PingChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AbstractLivelinessMonitor.this.stopped && !Thread.currentThread().isInterrupted()) {
                AbstractLivelinessMonitor abstractLivelinessMonitor = AbstractLivelinessMonitor.this;
                synchronized (abstractLivelinessMonitor) {
                    Iterator iterator = AbstractLivelinessMonitor.this.running.entrySet().iterator();
                    long currentTime = AbstractLivelinessMonitor.this.clock.getTime();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object key = entry.getKey();
                        long interval = AbstractLivelinessMonitor.this.getExpireInterval(key);
                        if (currentTime <= (Long)entry.getValue() + interval) continue;
                        iterator.remove();
                        AbstractLivelinessMonitor.this.expire(key);
                        LOG.info("Expired:" + entry.getKey().toString() + " Timed out after " + interval / 1000L + " secs");
                    }
                }
                try {
                    Thread.sleep(AbstractLivelinessMonitor.this.monitorInterval);
                }
                catch (InterruptedException e) {
                    LOG.info(AbstractLivelinessMonitor.this.getName() + " thread interrupted");
                    break;
                }
            }
        }
    }
}

