/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.cluster;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.transport.client.Client;

public class IndexCleanup {
    private static final Logger LOG = LogManager.getLogger(IndexCleanup.class);
    private final Client client;
    private final ClusterService clusterService;

    public IndexCleanup(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public void deleteDocsByQuery(String indexName, QueryBuilder queryForDeleteByQueryRequest, ActionListener<Long> listener) {
        DeleteByQueryRequest deleteRequest = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{indexName}).setQuery(queryForDeleteByQueryRequest).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN).setRefresh(true);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteRequest, ActionListener.wrap(response -> {
                long deleted = response.getDeleted();
                if (deleted > 0L) {
                    LOG.info("{} docs are deleted for index:{}", (Object)deleted, (Object)indexName);
                }
                listener.onResponse((Object)response.getDeleted());
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

