/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.optimizer.pattern;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.Property;
import com.facebook.presto.matching.PropertyPattern;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalNested;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.logical.LogicalWrite;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.storage.read.TableScanBuilder;

public final class Patterns {
    public static <T extends LogicalPlan> Pattern<LogicalFilter> filter(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalFilter.class).with(Patterns.source(pattern));
    }

    public static <T extends LogicalPlan> Pattern<LogicalAggregation> aggregate(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalAggregation.class).with(Patterns.source(pattern));
    }

    public static <T extends LogicalPlan> Pattern<LogicalSort> sort(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalSort.class).with(Patterns.source(pattern));
    }

    public static <T extends LogicalPlan> Pattern<LogicalLimit> limit(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalLimit.class).with(Patterns.source(pattern));
    }

    public static <T extends LogicalPlan> Pattern<LogicalHighlight> highlight(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalHighlight.class).with(Patterns.source(pattern));
    }

    public static <T extends LogicalPlan> Pattern<LogicalNested> nested(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalNested.class).with(Patterns.source(pattern));
    }

    public static <T extends LogicalPlan> Pattern<LogicalProject> project(Pattern<T> pattern) {
        return Pattern.typeOf(LogicalProject.class).with(Patterns.source(pattern));
    }

    public static Pattern<LogicalEval> evalCapture() {
        return Pattern.typeOf(LogicalEval.class).capturedAs(Capture.newCapture());
    }

    public static Pattern<TableScanBuilder> scanBuilder() {
        return Pattern.typeOf(TableScanBuilder.class).capturedAs(Capture.newCapture());
    }

    public static Property<LogicalPlan, LogicalPlan> source() {
        return Property.optionalProperty((String)"source", plan -> plan.getChild().size() == 1 ? Optional.of(plan.getChild().get(0)) : Optional.empty());
    }

    public static <T extends LogicalPlan> PropertyPattern<LogicalPlan, T> source(Pattern<T> pattern) {
        Property property = Property.optionalProperty((String)"source", plan -> plan.getChild().size() == 1 ? Optional.of(plan.getChild().get(0)) : Optional.empty());
        return property.matching(pattern);
    }

    public static Property<LogicalPlan, Table> table() {
        return Property.optionalProperty((String)"table", plan -> plan instanceof LogicalRelation ? Optional.of(((LogicalRelation)plan).getTable()) : Optional.empty());
    }

    public static Property<LogicalPlan, Table> writeTable() {
        return Property.optionalProperty((String)"table", plan -> plan instanceof LogicalWrite ? Optional.of(((LogicalWrite)plan).getTable()) : Optional.empty());
    }

    @Generated
    private Patterns() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

