/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;

public abstract class Scorer
extends Scorable {
    public abstract int docID();

    public abstract DocIdSetIterator iterator();

    public TwoPhaseIterator twoPhaseIterator() {
        return null;
    }

    public int advanceShallow(int target) throws IOException {
        return Integer.MAX_VALUE;
    }

    public abstract float getMaxScore(int var1) throws IOException;

    public void nextDocsAndScores(int upTo, Bits liveDocs, DocAndFloatFeatureBuffer buffer) throws IOException {
        int batchSize = 64;
        buffer.growNoCopy(batchSize);
        int size = 0;
        DocIdSetIterator iterator = this.iterator();
        int doc = this.docID();
        while (doc < upTo && size < batchSize) {
            if (liveDocs == null || liveDocs.get(doc)) {
                buffer.docs[size] = doc;
                buffer.features[size] = this.score();
                ++size;
            }
            doc = iterator.nextDoc();
        }
        buffer.size = size;
    }
}

