/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.file.PathTraversalChecker;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Not worth caching")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b!\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0019\u001a\u00020\u000b*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lorg/gradle/kotlin/dsl/resolver/FindGradleSources;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/gradle/api/artifacts/transform/TransformParameters$None;", "<init>", "()V", "input", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInput", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "processEntry", "prefix", "", "Lorg/gradle/kotlin/dsl/resolver/FindGradleSources$ProjectSourceOutputs;", "entry", "Ljava/util/zip/ZipEntry;", "zip", "Ljava/util/zip/ZipFile;", "processProjectEntry", "offset", "", "writeTo", "Ljava/io/InputStream;", "output", "Ljava/io/File;", "consumeDir", "consume", "toSkip", "ProjectSourceOutputs", "kotlin-dsl"})
public abstract class FindGradleSources
implements TransformAction<TransformParameters.None> {
    @PathSensitive(value=PathSensitivity.NONE)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        Closeable closeable = new ZipFile(((FileSystemLocation)this.getInput().get()).getAsFile());
        Throwable throwable = null;
        try {
            ZipFile zip2 = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> it = zip2.entries();
            if (!it.hasMoreElements()) {
                return;
            }
            ZipEntry first = it.nextElement();
            String string = first.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            int slashIndex = StringsKt.indexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (slashIndex < 0) {
                return;
            }
            String string2 = first.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = string2;
            int n = 0;
            int n2 = slashIndex + 1;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String rootPrefix = string4;
            ProjectSourceOutputs projectOutputs = new ProjectSourceOutputs(outputs, null, 2, null);
            Intrinsics.checkNotNull((Object)first);
            this.processEntry(rootPrefix, projectOutputs, first, zip2);
            while (it.hasMoreElements()) {
                ZipEntry zipEntry = it.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"nextElement(...)");
                this.processEntry(rootPrefix, projectOutputs, zipEntry, zip2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void processEntry(String prefix, ProjectSourceOutputs outputs, ZipEntry entry, ZipFile zip2) {
        int rootOffset = this.consume(prefix, 0, entry);
        if (rootOffset == -1) {
            return;
        }
        int subprojectsOffset = this.consume("subprojects/", rootOffset, entry);
        if (subprojectsOffset != -1) {
            this.processProjectEntry(subprojectsOffset, outputs, entry, zip2);
            return;
        }
        int platformsOffset = this.consume("platforms/", rootOffset, entry);
        if (platformsOffset != -1) {
            int platformDirOffset = this.consumeDir(platformsOffset, entry);
            if (platformDirOffset != -1) {
                this.processProjectEntry(platformDirOffset, outputs, entry, zip2);
            }
            return;
        }
    }

    private final void processProjectEntry(int offset, ProjectSourceOutputs outputs, ZipEntry entry, ZipFile zip2) {
        int projectNameOffset = this.consumeDir(offset, entry);
        if (projectNameOffset == -1) {
            return;
        }
        int srcMainOffset = this.consume("src/main/", projectNameOffset, entry);
        if (srcMainOffset == -1) {
            return;
        }
        int sourceDirectoryOffset = this.consumeDir(srcMainOffset, entry);
        if (sourceDirectoryOffset == -1 || entry.isDirectory()) {
            return;
        }
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        int n = projectNameOffset - 1;
        String string3 = string2.substring(offset, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String projectName = string3;
        File projectSrcOutputDir = outputs.dir(projectName);
        String string4 = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        String string5 = string4.substring(sourceDirectoryOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String string6 = PathTraversalChecker.safePathName((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"safePathName(...)");
        File output = FilesKt.resolve((File)projectSrcOutputDir, (String)string6);
        InputStream inputStream = zip2.getInputStream(entry);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.writeTo(inputStream, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeTo(InputStream $this$writeTo, File output) {
        output.getParentFile().mkdirs();
        Closeable closeable = $this$writeTo;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(output);
            Throwable throwable2 = null;
            try {
                FileOutputStream output2 = (FileOutputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output2, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final int consumeDir(int offset, @NotNull ZipEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        int dirIndex = StringsKt.indexOf$default((CharSequence)string, (char)'/', (int)offset, (boolean)false, (int)4, null);
        if (dirIndex >= 0) {
            return dirIndex + 1;
        }
        return -1;
    }

    public final int consume(@NotNull String toSkip, int offset, @NotNull ZipEntry entry) {
        Intrinsics.checkNotNullParameter((Object)toSkip, (String)"toSkip");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)toSkip, (int)offset, (boolean)false, (int)4, null)) {
            return offset + toSkip.length();
        }
        return -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gradle/kotlin/dsl/resolver/FindGradleSources$ProjectSourceOutputs;", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "dirs", "", "", "Ljava/io/File;", "<init>", "(Lorg/gradle/api/artifacts/transform/TransformOutputs;Ljava/util/Map;)V", "dir", "name", "kotlin-dsl"})
    @SourceDebugExtension(value={"SMAP\nFindGradleSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindGradleSources.kt\norg/gradle/kotlin/dsl/resolver/FindGradleSources$ProjectSourceOutputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    public static final class ProjectSourceOutputs {
        @NotNull
        private final TransformOutputs outputs;
        @NotNull
        private final Map<String, File> dirs;

        public ProjectSourceOutputs(@NotNull TransformOutputs outputs, @NotNull Map<String, File> dirs) {
            Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
            Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
            this.outputs = outputs;
            this.dirs = dirs;
        }

        public /* synthetic */ ProjectSourceOutputs(TransformOutputs transformOutputs, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map2 = new LinkedHashMap();
            }
            this(transformOutputs, map2);
        }

        @NotNull
        public final File dir(@NotNull String name) {
            File file;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            File dir = this.dirs.get(name);
            if (dir != null) {
                return dir;
            }
            File file2 = this.outputs.dir((Object)name);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"dir(...)");
            File it = file = file2;
            boolean bl = false;
            this.dirs.put(name, it);
            return file;
        }
    }
}

