/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.gradle.cache.Cache;

public class ManualEvictionInMemoryCache<K, V>
implements Cache<K, V> {
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap(256);

    @Override
    public V get(K key, Function<? super K, ? extends V> factory) {
        return this.map.computeIfAbsent((K)key, factory);
    }

    @Override
    public V getIfPresent(K key) {
        return this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public void retainAll(Collection<? extends K> keysToRetain) {
        this.map.keySet().retainAll(keysToRetain);
    }

    public void clear() {
        this.map.clear();
    }
}

