/* -*- Mode: C++; tab-width: 6 -*- */ 

/*
 *
 * This file is part of Script Communication Protocol (shorten to SCP), which are libraries for OpenTTD NoAI and NoGO
 * Copyright (C) 2012 Krinn <krinn@chez.com> & Zuu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* the GS header */

class _SCPLib_Share
{
	static LibraryMode = 1;	// 0 for ai, 1 for gs
	static LibAPIVersion = "1.2"; // the library API version
	static LibVersion = 45; // the library version
};

SCPSign <- GSSign;
SCPSignList <- GSSignList
SCPLog <- GSLog;
SCPMap <- GSMap;
SCPCompany <- GSCompany;
SCPList <- GSList;
SCPEventController <- GSEventController;
SCPEvent <- GSEvent;
SCPController <- GSController;
SCPBase <- GSBase;
SCPEventCompanyNew <- GSEventCompanyNew;
SCPEventCompanyBankrupt <- GSEventCompanyBankrupt;
SCPEventCompanyMerger <- GSEventCompanyMerger;
GSEventController._GetNextEvent <- GSEventController.GetNextEvent;
GSEventController.GetNextEvent <- function()
{
	local hook=GSEventController._GetNextEvent();
	_SCPLib_Events.NextEvent(hook);
	return hook;
}
