/*
 * This file is part of Transportgoals, which is a GameScript for OpenTTD
 * Copyright (C) 2011  Leif Linse
 *
 * Transportgoals is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * Transportgoals is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Transportgoals; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

require("version.nut");

class FTestGame extends GSInfo {
	function GetAuthor()		{ return "Zuu"; }
	function GetName()			{ return "TransportGoals"; }
	function GetDescription() 	{ return "Goal: Have a high ratio of cargo delivered / vehicle"; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()			{ return "2011-12-28"; }
	function CreateInstance()	{ return "TestGame"; }
	function GetShortName()		{ return "CDVC"; }
	function GetAPIVersion()	{ return "1.2"; }
	function GetUrl()			{ return "http://www.tt-forums.net/viewtopic.php?f=65&t=57877"; }

	function GetSettings() {
		AddSetting({name = "log_level", description = "Debug: Log level (higher = print more)", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = CONFIG_INGAME, min_value = 1, max_value = 3});
	}
}

RegisterGS(FTestGame());
