/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/

class Scheduler
{
static task_list = {}

	ID	= null;
	Timed = null;
	Ticker = null;
	check_func = null;

	constructor(id, clock)
    /** @brief Constructor
     *
     * @param id a string identifier for the task
     * @param clock an integer value of tick to trigger the task
     *
     */
	{
		this.ID = id;
		this.Ticker = clock + GSController.GetTick();
		this.Timed = clock;
		this.check_func = "AwardEvaluate_"+id;
		if (clock > 0)	{ Scheduler.task_list[id] <- this; }
	}
}

function Scheduler::RemoveTask(id)
/** @brief Remove a task from the scheduler
 *
 * @param id task string id to remove from the scheduler list
 *
 */
{
	if (id in Scheduler.task_list)	{ delete Scheduler.task_list[id]; }
}

function Scheduler::Advance()
/** @brief Advance tasks, incrementing tasks ticks, and check if one is triggered and need to be run
 *
 *
 */

{
	local elapse = GSController.GetTick();
	local runner = [];
	foreach (obj in Scheduler.task_list)
		{
		if (elapse >= obj.Ticker)	{ obj.Ticker = obj.Timed + elapse; runner.push(obj.ID); runner.push(obj.check_func); }
		}
	local starter = null;
	for (local i = 0; i < runner.len(); i++)
		{
		if (runner[i+1] in Scheduler)
				{
				local tm = GSController.GetTick();
				starter = Scheduler[runner[i+1]];
				local result = starter();
				GSLog.Info("checking award #"+runner[i]+" time = "+(GSController.GetTick() - tm));
				if (typeof(result) == "array")
						{ Awards.GrantAward(runner[i], result); }
				else	{
						if (result >= 0)	{ Awards.GrantAward(runner[i], [result]); }
						if (result == -1)	{ Awards.GrantAward(runner[i], []); }
						}
				}
		else	{
				GSLog.Warning("Function "+runner[i+1]+" not implemented yet !");
				}
		GSController.Sleep(1);
		i++;
		}
}

