/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/

class CompanyLayer
{
static	companyPage = [];	/**< Hold pageID */
static	GlobalElement = [];	/**< Hold elementID of rank & reward pages */
static	companyValue = [];	/**< Hold the value of a company or -1 if not yet calc */
static	companyPoints = [];	/**< Hold the points for each company */
	constructor()
	{
	for (local i = 0; i < 19*3; i++)	{ companyPage.push(-1); }
	for (local i = 0; i < 15; i++)	{ companyValue.push(null); companyPoints.push(-1); }
	for (local i = 0; i < 31; i++)	{ GlobalElement.push(-1); }
	}

	/** @brief Set the value of a company
	*
	* @param c_ID company ID
	* @param value value of company to set
	*
	*/
	function SetValue(c_ID, value);

	/** @brief Add points to a company
	*
	* @param c_ID company ID
	* @param points number of points to add
	*
	*/

	function AddPoints(c_ID, points);
	/** @brief Remove points from a company
	*
	* @param c_ID company ID
	* @param points number of points to remove
	*
	*/
	function RemovePoints(c_ID, points);

	/** @brief Get the PageID a company use
	*
	* @param c_ID companyID: 0-14 company index, 15 the welcome page, 16 rank, 17 medal, 18 reward
	* @param option company 0-14 0- VehiclePage, 1-Economy pageID, 2 - misc pageID
	* @param option company >= 15 always set to 0
	* @return the matching PageID for company
	*
	*/
	function GetPageID(c_ID, option);

	/** @brief Remove a company, reset all datas for next company addition
	*
	* @param c_ID company ID
	* @return
	*
	*/
	function RemoveCompany(c_ID);

	/** @brief Reset datas for a company
	*
	* @param c_ID companyID
	*
	*/
	function ValueReset(company);

	/** @brief Add a new company, create needed page in story book if they doesn't exist yet
	*
	* @param c_ID company ID
	*
	*/
	function NewCompany(c_ID);

	/** @brief Initialize global story page, add them to story book and create elementID on them
	*/
	function Init();

}

function CompanyLayer::SetValue(c_ID, value)
{
	CompanyLayer.companyValue[c_ID] = value;
}

function CompanyLayer::AddPoints(c_ID, points)
{
	if (c_ID == null)	{ return; } // when we remove an award
	local value = CompanyLayer.companyPoints[c_ID];
	if (value == -1)	{ value = 0; CompanyLayer.NewCompany(c_ID); }
	value += points;
	CompanyLayer.companyPoints[c_ID] = value;
}

function CompanyLayer::RemovePoints(c_ID, points)
{
	local value = CompanyLayer.companyPoints[c_ID];
	if (value == -1)	{ value = 0; CompanyLayer.NewCompany(c_ID); }
	value -= points;
	if (value < 0)	{ value = 0; }
	CompanyLayer.companyPoints[c_ID] = value;
}


function CompanyLayer::GetPageID(c_ID, option)
{
	if (c_ID < 0 || c_ID > 18)	{ GSLog.Error("Bad value for company ID in getpage : "+c_ID); return -1; }
	local idx = c_ID * 3;
	if (c_ID > 16 || c_ID == 15)	{ option = 0; } // return always page 0
	return CompanyLayer.companyPage[idx + option];
}

function CompanyLayer::RemoveCompany(c_ID)
{
	if (c_ID == -1)	{ return; }
	local idx = c_ID * 3;
	for (local z = 0; z < 3; z++)	{
									local h = CompanyLayer.GetPageID(c_ID, z);
									GSStoryPage.Remove(h);
									CompanyLayer.companyPage[idx + z] = -1;
									}
	CompanyLayer.companyValue[c_ID] = null;
	CompanyLayer.companyPoints[c_ID] = -1;
	Cache.SetData("companyDate", c_ID, 0);
	GSLog.Info("Removing company #"+c_ID);
	foreach (obj in Awards.awards_db)
		{
		local check = Utils.INArray(c_ID, obj.Own_By_Company);
		if (check != -1)
			{
			obj.Own_By_Company.remove(check);
			StoryTeller.DisplayAwards(obj.ID);
			}
		Awards.ElementID[(obj.ID * 15) + c_ID] = -1;
		}
	local cargo_list = GSCargoList();
	foreach (cargo, _ in cargo_list)
		{
		local label = GSCargo.GetCargoLabel(cargo);
		if (Utils.INArray(label, Cache.cargo_tracker) != -1)	{ Cache.SetData(label, c_ID, 0); } // reset tracked cargos
		}
}

function CompanyLayer::ValueReset(company)
{
	CompanyLayer.companyPoints[company] = 0;
	Cache.cargo_handle.SetValue(company, 0);
	Cache.vehicle[16] = 0; // force dirty vehicle cache
	Cache.vehicle[15] = GSList(); // force dirty vehicle cache
	Cache.vehicle[company] = GSList();
	Cache.SetData("town_supply", company, 0);
	Cache.SetData("industry_supply", company, 0);
	Cache.SetData("reward", company, 0);
	Cache.SetData("reward_balance", company, 0);
	Cache.SetData("gabriel", company, 0);
}

function CompanyLayer::NewCompany(c_ID)
{
	if (GSCompany.ResolveCompanyID(c_ID) == GSCompany.COMPANY_INVALID)	{ return; }
	local idx = c_ID * 3;
	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.companyPage[idx+0]))
		{ CompanyLayer.companyPage[idx+0] = StoryTeller.NewStoryPage(c_ID, GSText(GSText.STR_VEHICLE_TITLE)); }
	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.companyPage[idx+1]))
		{ CompanyLayer.companyPage[idx+1] = StoryTeller.NewStoryPage(c_ID, GSText(GSText.STR_ECONOMY_TITLE)); }
	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.companyPage[idx+2]))
		{ CompanyLayer.companyPage[idx+2] = StoryTeller.NewStoryPage(c_ID, GSText(GSText.STR_MISC_TITLE)); }
	if (!GSController.GetSetting("HiddenAward"))
			{
			foreach (ids in Awards.awards_db) { StoryTeller.DisplayAwards(ids.ID); }
			}
	local pinfo = "";
	for (local h = 0; h < 3; h++)	{ pinfo+="#"+CompanyLayer.companyPage[idx+h]+" "; }
	GSLog.Info("Adding company #"+c_ID+" "+GSCompany.GetName(c_ID)+" using page "+pinfo);
	if (Cache.GetData("companyDate", c_ID) == 0)	{ Cache.SetData("companyDate", c_ID, GSDate.GetCurrentDate()); }
	CompanyLayer.ValueReset(c_ID);
	Cache.Monitoring();
}

function CompanyLayer::Init()
{
	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.GetPageID(15,0)))	{ CompanyLayer.companyPage[15 * 3] = StoryTeller.NewStoryPage(GSCompany.COMPANY_INVALID, GSText(GSText.STR_WELCOME_TITLE)); }
	local points = Awards.CustomPoints[GSController.GetSetting("RewardPointsTrigger")];
	CompanyLayer.companyPage[15 * 3 + 1] = StoryTeller.StoryUpdate(CompanyLayer.GetPageID(15,0), CompanyLayer.companyPage[15 * 3 +1], GSText(GSText.STR_WELCOME1, Awards.awards_db.len(), GSText(GSText.STR_MEDALS_TITLE), GSText(GSText.STR_VEHICLE_TITLE), GSText(GSText.STR_ECONOMY_TITLE), GSText(GSText.STR_MISC_TITLE), points, GSText(GSText.STR_REWARDS_TITLE)));
	local translate = GSText(GSText.STR_WELCOME2, PointsType.EASY, PointsType.MEDIUM, PointsType.HARD, PointsType.MEDAL, GSText(GSText.STR_RANK_TITLE), GSText(GSText.STR_LGS_AUTHOR));
		CompanyLayer.companyPage[15 * 3 + 2] = StoryTeller.StoryUpdate(CompanyLayer.GetPageID(15,0), CompanyLayer.companyPage[15 * 3 +2], translate);

	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.GetPageID(16,0)))
		{
		CompanyLayer.companyPage[16 * 3] = StoryTeller.NewStoryPage(GSCompany.COMPANY_INVALID, GSText(GSText.STR_RANK_TITLE));
		local aim = CompanyLayer.GetPageID(16, 0);
		for (local j = 0; j < 15; j++)
			{
			CompanyLayer.GlobalElement[j] = StoryTeller.StoryUpdate(aim, -1, " ");
			}
		}
	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.GetPageID(17,0)))
		{
		CompanyLayer.companyPage[17 * 3] = StoryTeller.NewStoryPage(GSCompany.COMPANY_INVALID, GSText(GSText.STR_MEDALS_TITLE));
		}
	if (!GSStoryPage.IsValidStoryPage(CompanyLayer.GetPageID(18,0)))
	    {
		CompanyLayer.companyPage[18 * 3] = StoryTeller.NewStoryPage(GSCompany.COMPANY_INVALID, GSText(GSText.STR_REWARDS_TITLE));
		local aim = CompanyLayer.GetPageID(18, 0);
		CompanyLayer.GlobalElement[30] = StoryTeller.StoryUpdate(aim, -1, " ");
		for (local j = 15; j < 30; j++)
			{
			CompanyLayer.GlobalElement[j] = StoryTeller.StoryUpdate(aim, -1, " ");
			}
		}
	StoryTeller.UpdateRank();
}
