/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs.components;

import gravestone.block.BlockGSGraveStone;
import gravestone.block.GraveStoneHelper;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBlock;
import gravestone.structures.BoundingBoxHelper;
import gravestone.structures.GraveGenerationHelper;
import gravestone.structures.MobSpawnHelper;
import gravestone.structures.ObjectsGenerationHelper;
import gravestone.structures.catacombs.components.CatacombsBaseComponent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.World;

public class GraveCorridor
extends CatacombsBaseComponent {
    public static final int X_LENGTH = 7;
    public static final int HEIGHT = 5;
    public static final int Z_LENGTH = 5;

    public GraveCorridor(int direction, int level, Random random, int x, int y, int z) {
        super(direction, level);
        this.xShift = 1;
        this.field_74887_e = BoundingBoxHelper.getCorrectBox(direction, x, y, z, 7, 5, 5, this.xShift);
        this.goTop = true;
        this.topXEnd = 1;
        this.topZEnd = 4;
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        this.func_74878_a(world, this.field_74887_e, 1, 1, 1, 5, 3, 3);
        this.func_74878_a(world, this.field_74887_e, 2, 1, 0, 4, 3, 0);
        this.func_74882_a(world, this.field_74887_e, 2, 0, 1, 4, 0, 3, false, random, this.getCemeteryCatacombsStones());
        if (GraveStoneConfig.generatePilesOfBones) {
            this.func_151551_a(world, this.field_74887_e, random, 0.35f, 2, 1, 2, 5, 1, 3, (Block)GSBlock.pileOfBones, (Block)GSBlock.pileOfBones, false);
        }
        this.func_151549_a(world, this.field_74887_e, 1, 0, 0, 5, 0, 0, GSBlock.trap, GSBlock.trap, false);
        this.func_151549_a(world, this.field_74887_e, 1, 0, 4, 5, 0, 4, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 1, 0, 1, 1, 0, 3, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 5, 0, 1, 5, 0, 3, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 1, 4, 0, 5, 4, 4, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_74882_a(world, this.field_74887_e, 0, 0, 1, 0, 4, 3, false, random, this.getCemeteryCatacombsStones());
        this.func_74882_a(world, this.field_74887_e, 6, 0, 1, 6, 4, 3, false, random, this.getCemeteryCatacombsStones());
        this.func_74882_a(world, this.field_74887_e, 2, 0, 4, 4, 4, 4, false, random, this.getCemeteryCatacombsStones());
        this.func_151549_a(world, this.field_74887_e, 1, 1, 0, 1, 3, 0, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 1, 1, 4, 1, 3, 4, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 5, 1, 0, 5, 3, 0, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 5, 1, 4, 5, 3, 4, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        byte graveType = GraveStoneHelper.getGraveType(world, this.func_74865_a(0, 0), this.func_74873_b(0, 0), random, BlockGSGraveStone.EnumGraveType.ALL_GRAVES);
        Item sword = GraveStoneHelper.getRandomSwordForGeneration(graveType, random);
        int metaLeft = GraveStoneHelper.getMetaDirection(GraveCorridor.getLeftItemDirection(this.field_74885_f));
        int metaRight = GraveStoneHelper.getMetaDirection(GraveCorridor.getRightItemDirection(this.field_74885_f));
        GraveGenerationHelper.fillGraves(this, world, random, 1, 1, 1, 1, 1, 3, metaLeft, graveType, sword, true);
        GraveGenerationHelper.fillGraves(this, world, random, 5, 1, 1, 5, 1, 3, metaRight, graveType, sword, true);
        if (random.nextInt(5) < 2) {
            ObjectsGenerationHelper.generateChest(this, world, random, 3, 1, 2, true, ObjectsGenerationHelper.EnumChestTypes.ALL_CHESTS);
        }
        MobSpawnHelper.spawnBats(world, random, this.field_74887_e);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 2, 2, 1, 2, 2, 1, Blocks.field_150321_G, Blocks.field_150321_G, false);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 4, 1, 2, 4, 1, 2, Blocks.field_150321_G, Blocks.field_150321_G, false);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 3, 3, 3, 3, 3, 3, Blocks.field_150321_G, Blocks.field_150321_G, false);
        return true;
    }
}

