/*
 * Decompiled with CFR 0.152.
 */
package gravestone.renderer.item;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gravestone.core.Resources;
import gravestone.item.corpse.CatCorpseHelper;
import gravestone.item.corpse.HorseCorpseHelper;
import gravestone.item.corpse.VillagerCorpseHelper;
import gravestone.item.enums.EnumCorpse;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelOcelot;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemGSCorpseRenderer
implements IItemRenderer {
    private static final Map horsesTexturesMap = Maps.newHashMap();
    private static final ModelVillager villagerModel = new ModelVillager(0.0f);
    private static final ModelWolf dogModel = new ModelWolf();
    private static final ModelOcelot catModel = new ModelOcelot();
    private static final ModelHorse horseModel = new ModelHorse();
    private static EntityWolf dog;
    private static EntityHorse horse;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        byte corpseType = (byte)item.func_77960_j();
        float xz = 0.0625f;
        switch (EnumCorpse.getById(corpseType)) {
            case VILLAGER: {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                int profession = VillagerCorpseHelper.getVillagerType(item.func_77978_p());
                switch (profession) {
                    case 0: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.VILLAGER_FARMER);
                        break;
                    }
                    case 1: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.VILLAGER_LIBRARIAN);
                        break;
                    }
                    case 2: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.VILLAGER_PRIEST);
                        break;
                    }
                    case 3: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.VILLAGER_SMITH);
                        break;
                    }
                    case 4: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.VILLAGER_BUTCHER);
                        break;
                    }
                    default: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(VillagerRegistry.getVillagerSkin((int)profession, (ResourceLocation)Resources.VILLAGER));
                    }
                }
                villagerModel.func_78088_a(null, xz, xz, xz, xz, xz, xz);
                break;
            }
            case DOG: {
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.WOLF);
                if (dog == null) {
                    dog = new EntityWolf((World)Minecraft.func_71410_x().field_71441_e);
                }
                dogModel.func_78086_a((EntityLivingBase)dog, 0.0f, 0.0f, 0.0f);
                dogModel.func_78088_a((Entity)dog, xz, xz, xz, xz, xz, xz);
                break;
            }
            case CAT: {
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                byte catType = CatCorpseHelper.getCatType(item.func_77978_p());
                switch (catType) {
                    default: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.OCELOT);
                        break;
                    }
                    case 1: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.BLACK_CAT);
                        break;
                    }
                    case 2: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.RED_CAT);
                        break;
                    }
                    case 3: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.SIAMESE_CAT);
                    }
                }
                catModel.func_78088_a(null, xz, xz, xz, xz, xz, xz);
                break;
            }
            case HORSE: {
                GL11.glTranslatef((float)0.0f, (float)-0.6f, (float)0.0f);
                if (horse == null) {
                    horse = new EntityHorse((World)Minecraft.func_71410_x().field_71441_e);
                }
                horse.func_110214_p(HorseCorpseHelper.getHorseType(item.func_77978_p()));
                horse.func_110235_q(HorseCorpseHelper.getHorseVariant(item.func_77978_p()));
                switch (HorseCorpseHelper.getHorseType(item.func_77978_p())) {
                    case 0: {
                        String horseTexturePath = horse.func_110264_co();
                        ResourceLocation horseResourceLocation = (ResourceLocation)horsesTexturesMap.get(horseTexturePath);
                        if (horseResourceLocation == null) {
                            horseResourceLocation = new ResourceLocation(horseTexturePath);
                            Minecraft.func_71410_x().func_110434_K().func_110579_a(horseResourceLocation, (ITextureObject)new LayeredTexture(horse.func_110212_cp()));
                            horsesTexturesMap.put(horseTexturePath, horseResourceLocation);
                        }
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(horseResourceLocation);
                        break;
                    }
                    case 1: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.DONKEY);
                        break;
                    }
                    case 2: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.MULE);
                        break;
                    }
                    case 3: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.ZOMBIE_HORSE);
                        break;
                    }
                    case 4: {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.SKELETON_HORSE);
                    }
                }
                horseModel.func_78086_a((EntityLivingBase)horse, 0.0f, 0.0f, 0.0f);
                horseModel.func_78088_a((Entity)horse, xz, xz, xz, xz, xz, xz);
            }
        }
        GL11.glPopMatrix();
    }
}

