/*
 * Decompiled with CFR 0.152.
 */
package gravestone.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gravestone.core.GSMessageHandler;
import gravestone.item.ItemGSCorpse;
import gravestone.item.corpse.CorpseHelper;
import gravestone.packets.AltarMessageToClient;
import gravestone.tileentity.TileEntityGSAltar;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class AltarMessageToServer
implements IMessage,
IMessageHandler<AltarMessageToServer, IMessage> {
    private int playerID;
    private int dimensionID;
    private int x;
    private int y;
    private int z;
    private MOB_TYPE mobType;

    public AltarMessageToServer() {
    }

    public AltarMessageToServer(EntityPlayer player, int x, int y, int z, MOB_TYPE mobType) {
        this.playerID = player.func_145782_y();
        this.dimensionID = player.field_70170_p.field_73011_w.field_76574_g;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mobType = mobType;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerID = buf.readInt();
        this.dimensionID = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mobType = MOB_TYPE.getMobType(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerID);
        buf.writeInt(this.dimensionID);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.mobType.ordinal());
    }

    public IMessage onMessage(AltarMessageToServer message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            ItemStack corpse;
            TileEntityGSAltar tileEntity;
            WorldServer world = DimensionManager.getWorld((int)message.dimensionID);
            if (world == null || ctx.getServerHandler().field_147369_b != null && ctx.getServerHandler().field_147369_b.func_145782_y() != message.playerID) {
                return null;
            }
            EntityPlayer player = (EntityPlayer)world.func_73045_a(message.playerID);
            TileEntity te = world.func_147438_o(message.x, message.y, message.z);
            if (te != null && te instanceof TileEntityGSAltar && (tileEntity = (TileEntityGSAltar)te).hasCorpse() && (corpse = tileEntity.getCorpse()) != null && corpse.func_77973_b() instanceof ItemGSCorpse && CorpseHelper.canSpawnMob(player, corpse.func_77960_j())) {
                CorpseHelper.spawnMob(corpse.func_77960_j(), tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, corpse.field_77990_d, player);
                CorpseHelper.getExperience(player, corpse.func_77960_j());
                GSMessageHandler.networkWrapper.sendTo((IMessage)new AltarMessageToClient(), (EntityPlayerMP)player);
                tileEntity.setCorpse(null);
            }
        }
        return null;
    }

    public static enum MOB_TYPE {
        LIVED,
        ZOMBIE,
        SKELETON,
        GHOST;


        public static MOB_TYPE getMobType(int num) {
            if (MOB_TYPE.values().length <= num) {
                return LIVED;
            }
            return MOB_TYPE.values()[num];
        }
    }
}

