/*
 * Decompiled with CFR 0.152.
 */
package gravestone.item.corpse;

import cpw.mods.fml.common.registry.VillagerRegistry;
import gravestone.ModGraveStone;
import gravestone.config.GraveStoneConfig;
import gravestone.core.compatibility.forestry.GSCompatibilityForestry;
import gravestone.core.logger.GSLogger;
import gravestone.item.corpse.CorpseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class VillagerCorpseHelper
extends CorpseHelper {
    private VillagerCorpseHelper() {
    }

    public static List<ItemStack> getDefaultCorpses(Item item, int corpseType) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(VillagerCorpseHelper.getDefaultVillagerCorpse(item, corpseType, 0));
        list.add(VillagerCorpseHelper.getDefaultVillagerCorpse(item, corpseType, 1));
        list.add(VillagerCorpseHelper.getDefaultVillagerCorpse(item, corpseType, 2));
        list.add(VillagerCorpseHelper.getDefaultVillagerCorpse(item, corpseType, 3));
        list.add(VillagerCorpseHelper.getDefaultVillagerCorpse(item, corpseType, 4));
        Collection villagerIds = VillagerRegistry.getRegisteredVillagers();
        Iterator it = villagerIds.iterator();
        while (it.hasNext()) {
            list.add(VillagerCorpseHelper.getDefaultVillagerCorpse(item, corpseType, (Integer)it.next()));
        }
        return list;
    }

    private static ItemStack getDefaultVillagerCorpse(Item item, int corpseType, int type) {
        ItemStack corpse = new ItemStack(item, 1, corpseType);
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("VillagerType", type);
        corpse.func_77982_d(nbtTag);
        return corpse;
    }

    public static void setNbt(EntityVillager villager, NBTTagCompound nbt) {
        VillagerCorpseHelper.setName((EntityLiving)villager, nbt);
        nbt.func_74768_a("VillagerType", villager.func_70946_n());
        MerchantRecipeList recipes = villager.func_70934_b(null);
        if (recipes != null) {
            boolean correctRecipes = true;
            for (Object recipeObj : recipes) {
                MerchantRecipe recipe = (MerchantRecipe)recipeObj;
                if (recipe != null && recipe.func_77394_a() != null && recipe.func_77397_d() != null) {
                    NBTTagCompound recipeTag = recipe.func_77395_g();
                    recipeTag.func_74768_a("uses", 0);
                    recipeTag.func_74768_a("maxUses", 7);
                    recipe.func_77390_a(recipeTag);
                    continue;
                }
                correctRecipes = false;
            }
            if (recipes.size() > 0 && correctRecipes) {
                nbt.func_74782_a("Offers", (NBTBase)recipes.func_77202_a());
            } else {
                GSLogger.logError("Can't get villager recipes!");
            }
        }
    }

    public static void spawnVillager(World world, int x, int y, int z, NBTTagCompound nbtTag) {
        EntityVillager villager = new EntityVillager(world, VillagerCorpseHelper.getVillagerType(nbtTag));
        VillagerCorpseHelper.setMobName((EntityLiving)villager, nbtTag);
        NBTTagCompound nbt = new NBTTagCompound();
        villager.func_70014_b(nbt);
        if (VillagerCorpseHelper.hasTrades(nbtTag)) {
            nbt.func_74782_a("Offers", (NBTBase)nbtTag.func_74775_l("Offers"));
        }
        villager.func_70037_a(nbt);
        VillagerCorpseHelper.spawnMob((EntityLiving)villager, world, x, y, z);
    }

    public static int getVillagerType(NBTTagCompound nbtTag) {
        return nbtTag.func_74762_e("VillagerType");
    }

    public static void addInfo(List list, NBTTagCompound nbtTag) {
        VillagerCorpseHelper.addNameInfo(list, nbtTag);
        if (VillagerCorpseHelper.hasType(nbtTag)) {
            list.add(VillagerCorpseHelper.getType(nbtTag));
        }
        if (VillagerCorpseHelper.hasTrades(nbtTag)) {
            VillagerCorpseHelper.addTrades(list, nbtTag);
        }
    }

    private static boolean hasType(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("VillagerType");
    }

    private static String getType(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.villager_type") + " " + ModGraveStone.proxy.getLocalizedString(VillagerCorpseHelper.getVillagerProfession(VillagerCorpseHelper.getVillagerType(nbtTag)));
    }

    private static String getVillagerProfession(int type) {
        switch (type) {
            case 0: {
                return "item.corpse.villager_type.farmer";
            }
            case 1: {
                return "item.corpse.villager_type.librarian";
            }
            case 2: {
                return "item.corpse.villager_type.priest";
            }
            case 3: {
                return "item.corpse.villager_type.smith";
            }
            case 4: {
                return "item.corpse.villager_type.butcher";
            }
        }
        return VillagerCorpseHelper.getNotVanillaVillagerProfession(type);
    }

    private static String getNotVanillaVillagerProfession(int type) {
        if (type == GraveStoneConfig.undertakerId) {
            return "item.corpse.villager_type.undertaker";
        }
        if (type == GSCompatibilityForestry.getApicultureVillagerID()) {
            return "item.corpse.villager_type.beekeeper";
        }
        if (type == GSCompatibilityForestry.getArboricultureVillagerID()) {
            return "item.corpse.villager_type.lumberjack";
        }
        if (type == 10) {
            return "item.corpse.villager_type.brewer";
        }
        if (type == 206) {
            return "item.corpse.villager_type.thaumaturge";
        }
        return "item.corpse.villager_type.unknown";
    }

    private static boolean hasTrades(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("Offers");
    }

    private static void addTrades(List list, NBTTagCompound nbtTag) {
        if (VillagerCorpseHelper.hasTrades(nbtTag)) {
            MerchantRecipeList trades = new MerchantRecipeList(nbtTag.func_74775_l("Offers"));
            for (Object trade : trades) {
                MerchantRecipe recipe = (MerchantRecipe)trade;
                StringBuilder str = new StringBuilder();
                str.append(recipe.func_77394_a().field_77994_a).append(" ").append(recipe.func_77394_a().func_82833_r());
                if (recipe.func_77396_b() != null) {
                    str.append(" + ").append(recipe.func_77396_b().field_77994_a).append(" ").append(recipe.func_77394_a().func_82833_r());
                }
                str.append(" -> ").append(recipe.func_77397_d().field_77994_a).append(" ").append(recipe.func_77397_d().func_82833_r());
                list.add(str.toString());
            }
        }
    }
}

