/*
 * Decompiled with CFR 0.152.
 */
package gravestone.entity.monster;

import gravestone.core.GSBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySkullCrawler
extends EntityMob {
    protected int allySummonCooldown;
    protected int defaultSummonCooldown = 10;

    public EntitySkullCrawler(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
    }

    protected Entity func_70782_k() {
        return this.field_70170_p.func_72856_b((Entity)this, 10.0);
    }

    protected String func_70639_aQ() {
        return "mob.skeleton.say";
    }

    protected String func_70621_aR() {
        return "mob.skeleton.say";
    }

    protected String func_70673_aS() {
        return "mob.skeleton.death";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected void func_70785_a(Entity entity, float par2) {
        if (par2 > 2.0f && par2 < 6.0f && this.field_70146_Z.nextInt(10) == 0) {
            if (this.field_70122_E) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
        } else {
            super.func_70785_a(entity, par2);
        }
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.allySummonCooldown <= 0 && (source instanceof EntityDamageSource || source == DamageSource.field_76376_m)) {
            this.allySummonCooldown = this.defaultSummonCooldown;
        }
        return super.func_70097_a(source, par2);
    }

    public float func_70783_a(int x, int y, int z) {
        return this.field_70170_p.func_147439_a(x, y - 1, z).equals(Blocks.field_150348_b) ? 10.0f : super.func_70783_a(x, y, z);
    }

    protected Item func_146068_u() {
        return Items.field_151103_aS;
    }

    protected void func_70600_l(int par1) {
        this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean par1) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = par1 ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(this.getPotionEffect());
            }
            return true;
        }
        return false;
    }

    protected PotionEffect getPotionEffect() {
        return new PotionEffect(Potion.field_76421_d.field_76415_H, 200);
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c(1.0f);
            if (!this.field_70178_ae && f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    protected void func_70626_be() {
        super.func_70626_be();
        this.silverfishLikeBehaviour();
    }

    protected void silverfishLikeBehaviour() {
        if (!this.field_70170_p.field_72995_K) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.allySummonCooldown > 0) {
                --this.allySummonCooldown;
                if (this.allySummonCooldown == 0) {
                    boolean flag = false;
                    int shiftY = 0;
                    while (!flag && shiftY <= 5 && shiftY >= -5) {
                        int shiftX = 0;
                        while (!flag && shiftX <= 10 && shiftX >= -10) {
                            int ShiftZ = 0;
                            while (!flag && ShiftZ <= 10 && ShiftZ >= -10) {
                                Block block = this.field_70170_p.func_147439_a(x + shiftX, y + shiftY, z + ShiftZ);
                                int blockMeta = this.field_70170_p.func_72805_g(x + shiftX, y + shiftY, z + ShiftZ);
                                if (block.equals((Object)GSBlock.boneBlock) && GSBlock.boneBlock.isSkullCrawlerBlock(blockMeta)) {
                                    this.field_70170_p.func_147480_a(x + shiftX, y + shiftY, z + ShiftZ, false);
                                    GSBlock.boneBlock.func_149664_b(this.field_70170_p, x + shiftX, y + shiftY, z + ShiftZ, blockMeta);
                                    if (this.field_70146_Z.nextBoolean()) {
                                        flag = true;
                                        break;
                                    }
                                }
                                ShiftZ = ShiftZ <= 0 ? 1 - ShiftZ : 0 - ShiftZ;
                            }
                            shiftX = shiftX <= 0 ? 1 - shiftX : 0 - shiftX;
                        }
                        shiftY = shiftY <= 0 ? 1 - shiftY : 0 - shiftY;
                    }
                }
            }
            if (this.field_70789_a == null && !this.func_70781_l()) {
                int offset = this.field_70146_Z.nextInt(6);
                y = MathHelper.func_76128_c((double)(this.field_70163_u + 0.5)) + Facing.field_71587_c[offset];
                Block block = this.field_70170_p.func_147439_a(x += Facing.field_71586_b[offset], y, z += Facing.field_71585_d[offset]);
                int metadata = this.field_70170_p.func_72805_g(x, y, z);
                if (((Object)((Object)GSBlock.boneBlock)).equals(block) && !GSBlock.boneBlock.isSkullCrawlerBlock(metadata)) {
                    this.field_70170_p.func_147465_d(x, y, z, (Block)GSBlock.boneBlock, metadata + 2, 3);
                    this.func_70656_aK();
                    this.func_70106_y();
                } else {
                    this.func_70779_j();
                }
            } else if (this.field_70789_a != null && !this.func_70781_l()) {
                this.field_70789_a = null;
            }
        }
    }

    public static enum SkullCrawlerType {
        skeleton,
        wither,
        zombie;

    }
}

