/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final int genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public static final List<WeightedRandomBlock> fabricateList(WeightedRandomBlock weightedRandomBlock) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        arrayList.add(weightedRandomBlock);
        return arrayList;
    }

    public static final List<WeightedRandomBlock> fabricateList(Block block) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        arrayList.add(new WeightedRandomBlock(new ItemStack(block, 1, 0)));
        return arrayList;
    }

    public WorldGenMinableCluster(ItemStack itemStack, int n) {
        this(new WeightedRandomBlock(itemStack), n);
    }

    public WorldGenMinableCluster(WeightedRandomBlock weightedRandomBlock, int n) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> list, int n) {
        this(list, n, Blocks.field_150348_b);
    }

    public WorldGenMinableCluster(ItemStack itemStack, int n, Block block) {
        this(new WeightedRandomBlock(itemStack, 1), n, block);
    }

    public WorldGenMinableCluster(WeightedRandomBlock weightedRandomBlock, int n, Block block) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n, block);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> list, int n, Block block) {
        this(list, n, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        this.cluster = list;
        this.genClusterSize = n > 32 ? 32 : n;
        this.genBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        int n4 = this.genClusterSize;
        if (n4 < 4) {
            return this.generateTiny(world, random, n, n2, n3);
        }
        float f = random.nextFloat() * (float)Math.PI;
        float f2 = (float)(n + 8) + MathHelper.func_76126_a((float)f) * (float)n4 / 8.0f;
        float f3 = (float)(n + 8) - MathHelper.func_76126_a((float)f) * (float)n4 / 8.0f;
        float f4 = (float)(n3 + 8) + MathHelper.func_76134_b((float)f) * (float)n4 / 8.0f;
        float f5 = (float)(n3 + 8) - MathHelper.func_76134_b((float)f) * (float)n4 / 8.0f;
        float f6 = n2 + random.nextInt(3) - 2;
        float f7 = n2 + random.nextInt(3) - 2;
        f3 -= f2;
        f7 -= f6;
        f5 -= f4;
        boolean bl = false;
        for (int i = 0; i <= n4; ++i) {
            float f8 = f2 + f3 * (float)i / (float)n4;
            float f9 = f6 + f7 * (float)i / (float)n4;
            float f10 = f4 + f5 * (float)i / (float)n4;
            float f11 = (float)random.nextDouble() * (float)n4 / 16.0f;
            float f12 = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)n4)) + 1.0f) * f11 + 1.0f) * 0.5f;
            float f13 = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)n4)) + 1.0f) * f11 + 1.0f) * 0.5f;
            int n5 = MathHelper.func_76141_d((float)(f8 - f12));
            int n6 = MathHelper.func_76141_d((float)(f9 - f13));
            int n7 = MathHelper.func_76141_d((float)(f10 - f12));
            int n8 = MathHelper.func_76141_d((float)(f8 + f12));
            int n9 = MathHelper.func_76141_d((float)(f9 + f13));
            int n10 = MathHelper.func_76141_d((float)(f10 + f12));
            for (int j = n5; j <= n8; ++j) {
                float f14 = ((float)j + 0.5f - f8) / f12;
                if ((f14 *= f14) >= 1.0f) continue;
                for (int k = n6; k <= n9; ++k) {
                    float f15;
                    float f16 = ((float)k + 0.5f - f9) / f13;
                    if ((f15 = (f16 *= f16) + f14) >= 1.0f) continue;
                    for (int i2 = n7; i2 <= n10; ++i2) {
                        float f17 = ((float)i2 + 0.5f - f10) / f12;
                        if ((f17 *= f17) + f15 >= 1.0f) continue;
                        bl |= WorldGenMinableCluster.generateBlock(world, j, k, i2, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return bl;
    }

    public boolean generateTiny(World world, Random random, int n, int n2, int n3) {
        boolean bl = false;
        for (int i = 0; i < this.genClusterSize; ++i) {
            int n4 = n + random.nextInt(2);
            int n5 = n2 + random.nextInt(2);
            int n6 = n3 + random.nextInt(2);
            bl |= WorldGenMinableCluster.generateBlock(world, n4, n5, n6, this.genBlock, this.cluster);
        }
        return bl;
    }

    public static boolean canGenerateInBlock(World world, int n, int n2, int n3, WeightedRandomBlock[] weightedRandomBlockArray) {
        if (weightedRandomBlockArray == null || weightedRandomBlockArray.length == 0) {
            return true;
        }
        Block block = world.func_147439_a(n, n2, n3);
        for (WeightedRandomBlock weightedRandomBlock : weightedRandomBlockArray) {
            if (-1 != weightedRandomBlock.metadata && weightedRandomBlock.metadata != world.func_72805_g(n, n2, n3) || !block.isReplaceableOreGen(world, n, n2, n3, weightedRandomBlock.block) && !block.func_149667_c(weightedRandomBlock.block)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateBlock(World world, int n, int n2, int n3, WeightedRandomBlock[] weightedRandomBlockArray, List<WeightedRandomBlock> list) {
        if (weightedRandomBlockArray == null || weightedRandomBlockArray.length == 0) {
            return WorldGenMinableCluster.generateBlock(world, n, n2, n3, list);
        }
        if (WorldGenMinableCluster.canGenerateInBlock(world, n, n2, n3, weightedRandomBlockArray)) {
            return WorldGenMinableCluster.generateBlock(world, n, n2, n3, list);
        }
        return false;
    }

    public static boolean generateBlock(World world, int n, int n2, int n3, List<WeightedRandomBlock> list) {
        WeightedRandomBlock weightedRandomBlock = WorldGenMinableCluster.selectBlock(world, list);
        if (weightedRandomBlock == null) {
            return false;
        }
        return world.func_147465_d(n, n2, n3, weightedRandomBlock.block, weightedRandomBlock.metadata, 2);
    }

    public static WeightedRandomBlock selectBlock(World world, List<WeightedRandomBlock> list) {
        int n = list.size();
        if (n == 0) {
            return null;
        }
        if (n > 1) {
            return (WeightedRandomBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, list);
        }
        return list.get(0);
    }
}

