/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.items.ItemBucketGC;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.EventHandlerMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockSludge;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.dimension.TeleportTypeMars;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityLandingBalloons;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityProjectileTNT;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySludgeling;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import micdoodle8.mods.galacticraft.planets.mars.recipe.RecipeManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.schematic.SchematicCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.schematic.SchematicTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityDungeonSpawnerMars;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityHydrogenPipe;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntitySlimelingEgg;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTreasureChestMars;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MarsModule
implements IPlanetsModule {
    public static final String ASSET_PREFIX = "galacticraftmars";
    public static final String TEXTURE_PREFIX = "galacticraftmars:";
    public static Fluid sludge;
    public static Fluid sludgeGC;
    public static Material sludgeMaterial;
    public static Planet planetMars;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMars());
        if (!FluidRegistry.isFluidRegistered((String)"bacterialsludge")) {
            sludgeGC = new Fluid("bacterialsludge").setDensity(800).setViscosity(1500);
            FluidRegistry.registerFluid((Fluid)sludgeGC);
        } else {
            GCLog.info((String)"Galacticraft sludge is not default, issues may occur.");
        }
        sludge = FluidRegistry.getFluid((String)"bacterialsludge");
        if (sludge.getBlock() == null) {
            MarsBlocks.blockSludge = new BlockSludge().func_149663_c("sludge");
            ((BlockSludge)MarsBlocks.blockSludge).setQuantaPerBlock(3);
            GameRegistry.registerBlock((Block)MarsBlocks.blockSludge, ItemBlockDesc.class, (String)MarsBlocks.blockSludge.func_149739_a());
            sludge.setBlock(MarsBlocks.blockSludge);
        } else {
            MarsBlocks.blockSludge = sludge.getBlock();
        }
        if (MarsBlocks.blockSludge != null) {
            MarsItems.bucketSludge = new ItemBucketGC(MarsBlocks.blockSludge, TEXTURE_PREFIX).func_77655_b("bucketSludge");
            MarsItems.registerItem(MarsItems.bucketSludge);
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)"bacterialsludge", (int)1000), (ItemStack)new ItemStack(MarsItems.bucketSludge), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        EventHandlerGC.bucketList.put(MarsBlocks.blockSludge, MarsItems.bucketSludge);
        MarsBlocks.initBlocks();
        MarsBlocks.registerBlocks();
        MarsBlocks.setHarvestLevels();
        MarsBlocks.oreDictRegistration();
        MarsItems.initItems();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.registerMicroBlocks();
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier2Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicCargoRocket());
        GalacticraftCore.packetPipeline.addDiscriminator(6, PacketSimpleMars.class);
        this.registerTileEntities();
        this.registerCreatures();
        this.registerOtherEntities();
        planetMars = (Planet)new Planet("mars").setParentSolarSystem(GalacticraftCore.solarSystemSol).setRingColorRGB(0.67f, 0.1f, 0.1f).setPhaseShift(0.1667f).setRelativeSize(0.5319f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.25f, 1.25f)).setRelativeOrbitTime(1.881161f);
        planetMars.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/mars.png"));
        planetMars.setDimensionInfo(ConfigManagerMars.dimensionIDMars, WorldProviderMars.class).setTierRequired(2);
        planetMars.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.NITROGEN);
        GalaxyRegistry.registerPlanet((Planet)planetMars);
        GalacticraftRegistry.registerTeleportType(WorldProviderMars.class, (ITeleportType)new TeleportTypeMars());
        GalacticraftRegistry.registerRocketGui(WorldProviderMars.class, (ResourceLocation)new ResourceLocation(ASSET_PREFIX, "textures/gui/marsRocketGui.png"));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 1));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        GalacticraftRegistry.addDungeonLoot((int)3, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(MarsItems.marsItemBasic, 1, 3), (Object[])new Object[]{new ItemStack(GCItems.heavyPlatingTier1), new ItemStack(GCItems.meteoricIronIngot, 1, 1)});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(MarsItems.marsItemBasic, 1, 5), (Object[])new Object[]{new ItemStack(MarsItems.marsItemBasic, 1, 2)});
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        RecipeManagerMars.loadRecipes();
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Override
    public void serverInit(FMLServerStartedEvent event) {
    }

    private void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(MarsBlocks.marsBlock, 4), "tile.mars.marscobblestone");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(MarsBlocks.marsBlock, 5), "tile.mars.marsgrass");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(MarsBlocks.marsBlock, 6), "tile.mars.marsdirt");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(MarsBlocks.marsBlock, 7), "tile.mars.marsdungeon");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(MarsBlocks.marsBlock, 8), "tile.mars.marsdeco");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(MarsBlocks.marsBlock, 9), "tile.mars.marsstone");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntitySlimelingEgg.class, (String)"Slimeling Egg");
        GameRegistry.registerTileEntity(TileEntityTreasureChestMars.class, (String)"Tier 2 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityTerraformer.class, (String)"Planet Terraformer");
        GameRegistry.registerTileEntity(TileEntityCryogenicChamber.class, (String)"Cryogenic Chamber");
        GameRegistry.registerTileEntity(TileEntityGasLiquefier.class, (String)"Gas Liquefier");
        GameRegistry.registerTileEntity(TileEntityMethaneSynthesizer.class, (String)"Methane Synthesizer");
        GameRegistry.registerTileEntity(TileEntityElectrolyzer.class, (String)"Water Electrolyzer");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerMars.class, (String)"Mars Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityLaunchController.class, (String)"Launch Controller");
        GameRegistry.registerTileEntity(TileEntityHydrogenPipe.class, (String)"Hydrogen Pipe");
    }

    public void registerCreatures() {
        this.registerGalacticraftCreature(EntitySludgeling.class, "Sludgeling", ColorUtil.to32BitColor((int)255, (int)0, (int)50, (int)0), ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)0));
        this.registerGalacticraftCreature(EntitySlimeling.class, "Slimeling", ColorUtil.to32BitColor((int)255, (int)0, (int)50, (int)0), ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)0));
        this.registerGalacticraftCreature(EntityCreeperBoss.class, "CreeperBoss", ColorUtil.to32BitColor((int)255, (int)0, (int)50, (int)0), ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)0));
    }

    public void registerOtherEntities() {
        MarsModule.registerGalacticraftNonMobEntity(EntityTier2Rocket.class, "SpaceshipT2", 150, 1, false);
        MarsModule.registerGalacticraftNonMobEntity(EntityProjectileTNT.class, "ProjectileTNT", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityLandingBalloons.class, "LandingBalloons", 150, 5, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityCargoRocket.class, "CargoRocket", 150, 1, false);
    }

    public void registerGalacticraftCreature(Class<? extends Entity> var0, String var1, int back, int fore) {
        MarsModule.registerGalacticraftNonMobEntity(var0, var1, 80, 3, true);
        int nextEggID = GCCoreUtil.getNextValidEggID();
        if (nextEggID < 65536) {
            EntityList.field_75623_d.put(nextEggID, var0);
            VersionUtil.putClassToIDMapping(var0, (int)nextEggID);
            EntityList.field_75627_a.put(nextEggID, new EntityList.EntityEggInfo(nextEggID, back, fore));
        }
    }

    public static void registerGalacticraftNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            LanguageRegistry.instance().addStringLocalization("entity.GalacticraftMars." + var1 + ".name", GCCoreUtil.translate((String)("entity." + var1 + ".name")));
        }
        EntityRegistry.registerModEntity(var0, (String)var1, (int)GCCoreUtil.nextInternalID(), (Object)GalacticraftPlanets.instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(2);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.SERVER) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (ID == 2) {
                if (tile instanceof TileEntityTerraformer) {
                    return new ContainerTerraformer(player.field_71071_by, (TileEntityTerraformer)tile);
                }
                if (tile instanceof TileEntityLaunchController) {
                    return new ContainerLaunchController(player.field_71071_by, (TileEntityLaunchController)tile);
                }
                if (tile instanceof TileEntityElectrolyzer) {
                    return new ContainerElectrolyzer(player.field_71071_by, (TileEntityElectrolyzer)tile);
                }
                if (tile instanceof TileEntityGasLiquefier) {
                    return new ContainerGasLiquefier(player.field_71071_by, (TileEntityGasLiquefier)tile);
                }
                if (tile instanceof TileEntityMethaneSynthesizer) {
                    return new ContainerMethaneSynthesizer(player.field_71071_by, (TileEntityMethaneSynthesizer)tile);
                }
            }
        }
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigManagerMars.config;
    }

    @Override
    public void syncConfig() {
        ConfigManagerMars.syncConfig(false, false);
    }

    static {
        sludgeMaterial = new MaterialLiquid(MapColor.field_151669_i);
    }
}

