/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.pau101.fairylights.tileentity.TileEntityFairyLightsFastener;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;

public class Light {
    private Point3f point;
    private Vector3f rotation;
    private Vector3f color;
    private float brightness;
    private int twinkleTime;
    private static final int NORMAL_LIGHT = -1;
    private int tickCycle = 40;
    private int sway;
    private boolean swaying;
    private boolean swayDirection;
    private int swayRate = 10;
    private int swayPeakCount = 5;
    private int swayCycle = this.swayRate * this.swayPeakCount;

    public Light(Point3f point) {
        this.point = point;
        this.rotation = new Vector3f();
        this.color = new Vector3f(1.0f, 0.91764706f, 0.75686276f);
        this.brightness = 1.0f;
        this.twinkleTime = -1;
        this.sway = 0;
        this.swaying = false;
    }

    private double brightnessFunc(double x) {
        return Math.sqrt(1.0 - x * x) / Math.pow(78.5, Math.pow(x - 0.47, 2.0)) * 1.11358575;
    }

    public Point3f getAbsolutePoint(TileEntityFairyLightsFastener fastener) {
        Point3f point = this.getPoint();
        point.scale(0.0625f);
        point.add(fastener.getConnectionPoint());
        return point;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public Vector3f getLight() {
        return this.color;
    }

    public Point3f getPoint() {
        return new Point3f(this.point);
    }

    public Vector3f getRotation() {
        return new Vector3f(this.rotation);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setColor(Vector3f color) {
        this.color = color;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void startSwaying() {
        this.swayDirection = Math.random() < 0.5;
        this.swaying = true;
        this.sway = 0;
    }

    public void stopSwaying() {
        this.sway = 0;
        this.rotation.z = 0.0f;
        this.swaying = false;
    }

    public void tick(TileEntityFairyLightsFastener.Connection connection, boolean twinkle) {
        if (twinkle) {
            if ((double)connection.getWorldObj().field_73012_v.nextFloat() < 0.05 && this.twinkleTime == -1) {
                this.twinkleTime = 0;
            }
            if (this.twinkleTime >= 0) {
                double x = (double)this.twinkleTime / (double)this.tickCycle * 2.0 - 1.0;
                this.brightness = (float)(1.0 - this.brightnessFunc(x));
                ++this.twinkleTime;
            }
            if (this.twinkleTime == this.tickCycle) {
                this.brightness = 1.0f;
                this.twinkleTime = -1;
            }
        }
        if (this.swaying) {
            if (this.sway == this.swayCycle) {
                this.stopSwaying();
            }
            this.rotation.z = (float)(Math.sin((double)((this.swayDirection ? 1 : -1) * 2) * Math.PI / (double)this.swayRate * (double)this.sway) * Math.pow(114.59155902616465, (float)(-this.sway++) / (float)this.swayCycle));
        }
    }
}

