/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.tileentity;

import com.google.common.base.Charsets;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.block.BlockFairyLightsFastener;
import com.pau101.fairylights.eggs.JinglePlayer;
import com.pau101.fairylights.player.PlayerData;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.Light;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Point3i;
import com.pau101.fairylights.util.vectormath.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityFairyLightsFastener
extends TileEntity {
    private List<Connection> connections = new ArrayList<Connection>();
    private Point3f min = new Point3f();
    private Point3f max = new Point3f(1.0f, 1.0f, 1.0f);
    private Point3f connectionPoint = null;

    private void calculateBoundingBox() {
        for (Connection connection : this.connections) {
            Catenary catenary = connection.getCatenary();
            if (catenary == null) continue;
            for (Segment segment : catenary.getSegments()) {
                Point3f vertex = segment.getVertex();
                this.min.x = vertex.x < this.min.x ? vertex.x : this.min.x;
                this.min.y = vertex.y < this.min.y ? vertex.y : this.min.y;
                this.min.z = vertex.z < this.min.z ? vertex.z : this.min.z;
                this.max.x = vertex.x > this.max.x ? vertex.x : this.max.x;
                this.max.y = vertex.y > this.max.y ? vertex.y : this.max.y;
                this.max.z = vertex.z > this.max.z ? vertex.z : this.max.z;
            }
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void connectWith(EntityPlayer entity, NBTTagCompound tagCompound) {
        this.connections.add(new PlayerConnection(this.field_145850_b, entity, tagCompound));
    }

    public void connectWith(TileEntityFairyLightsFastener fairyLightsFastener, NBTTagCompound tagCompound) {
        this.connections.add(new FastenerConnection(this.field_145850_b, fairyLightsFastener.field_145851_c, fairyLightsFastener.field_145848_d, fairyLightsFastener.field_145849_e, true, tagCompound));
        fairyLightsFastener.connections.add(new FastenerConnection(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false, tagCompound));
    }

    public Point3f getConnectionPoint() {
        if (this.connectionPoint == null) {
            this.connectionPoint = ((BlockFairyLightsFastener)this.func_145838_q()).getOffsetForData(this.func_145832_p(), 0.125f).add(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.connectionPoint;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public List<Connection> getConnectionsForRender() {
        ArrayList<Connection> connectionsVertices = new ArrayList<Connection>(this.connections.size());
        for (Connection connection : this.connections) {
            Segment[] vertices;
            Catenary catenary;
            if (!connection.isOrigin || (catenary = connection.getCatenary()) == null || connection.getTo() == null || (vertices = catenary.getSegments()) == null) continue;
            connectionsVertices.add(connection);
        }
        return connectionsVertices;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.min.x / 16.0f), (double)(this.min.y / 16.0f), (double)(this.min.z / 16.0f), (double)(this.max.x / 16.0f), (double)(this.max.y / 16.0f), (double)(this.max.z / 16.0f)).func_72314_b(10.0, 10.0, 10.0).func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("connections", 9)) {
            this.connections.clear();
            NBTTagList listConnections = compound.func_150295_c("connections", 10);
            for (int i = 0; i < listConnections.func_74745_c(); ++i) {
                Connection connection;
                NBTTagCompound connectionCompound = listConnections.func_150305_b(i);
                if (connectionCompound.func_150297_b("UUIDMost", 4) && connectionCompound.func_150297_b("UUIDLeast", 4)) {
                    connection = new PlayerConnection(this.field_145850_b);
                } else {
                    if (!connectionCompound.func_150297_b("x", 99) || !connectionCompound.func_150297_b("y", 99) || !connectionCompound.func_150297_b("z", 99)) continue;
                    connection = new FastenerConnection(this.field_145850_b);
                }
                ((Connection)connection).readFromNBT(connectionCompound);
                this.connections.add(connection);
            }
        }
    }

    public void removeConnection(Entity entity) {
        for (Connection connection : this.connections) {
            if (!(connection instanceof PlayerConnection) || !entity.func_110124_au().equals(((PlayerConnection)connection).entityUUID) && (!(entity instanceof EntityPlayer) || !UUID.nameUUIDFromBytes(("OfflinePlayer:" + ((EntityPlayer)entity).func_146103_bH().getName()).getBytes(Charsets.UTF_8)).equals(((PlayerConnection)connection).entityUUID))) continue;
            ((PlayerConnection)connection).forceRemove = true;
        }
    }

    public void func_145834_a(World worldObj) {
        super.func_145834_a(worldObj);
        for (Connection connection : this.connections) {
            connection.worldObj = worldObj;
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.connections.size() == 0) {
            if (this.func_145838_q() == FairyLights.fairyLightsFastener) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (this.func_145838_q() == FairyLights.fairyLightsFence) {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150422_aJ);
            }
            return;
        }
        ArrayList<Connection> removeList = new ArrayList<Connection>();
        Point3f fromOffset = ((BlockFairyLightsFastener)this.func_145838_q()).getOffsetForData(this.func_145832_p(), 0.125f);
        fromOffset.x += (float)this.field_145851_c;
        fromOffset.y += (float)this.field_145848_d;
        fromOffset.z += (float)this.field_145849_e;
        boolean update = false;
        for (Connection connection : this.connections) {
            update |= connection.shouldRecalculateCatenary;
            connection.update(fromOffset);
            if (!connection.shouldDisconnect()) continue;
            update = true;
            connection.onRemove();
            removeList.add(connection);
        }
        this.connections.removeAll(removeList);
        if (update) {
            this.calculateBoundingBox();
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList listConnections = new NBTTagList();
        for (int i = 0; i < this.connections.size(); ++i) {
            NBTTagCompound connectionCompound = new NBTTagCompound();
            this.connections.get(i).writeToNBT(connectionCompound);
            listConnections.func_74742_a((NBTBase)connectionCompound);
        }
        compound.func_74782_a("connections", (NBTBase)listConnections);
    }

    public class PlayerConnection
    extends Connection {
        private EntityPlayer entity;
        private UUID entityUUID;
        public boolean forceRemove;
        private NBTTagCompound details;

        private PlayerConnection(World worldObj) {
            super(worldObj);
            this.entity = null;
        }

        public PlayerConnection(World worldObj, EntityPlayer entity, NBTTagCompound tagCompound) {
            super(worldObj, true, tagCompound);
            this.entity = entity;
            this.entityUUID = entity.func_110124_au();
            this.forceRemove = false;
        }

        @Override
        public Point3f getTo() {
            if (this.entity == null) {
                return null;
            }
            Point3f point = new Point3f((float)this.entity.field_70165_t, (float)this.entity.field_70163_u, (float)this.entity.field_70161_v);
            point.x += MathHelper.func_76134_b((float)((this.entity.field_70760_ar - 180.0f) / 180.0f * (float)Math.PI)) * 0.4f;
            point.z += MathHelper.func_76126_a((float)((this.entity.field_70760_ar - 180.0f) / 180.0f * (float)Math.PI)) * 0.4f;
            point.y += FairyLights.proxy.getCatenaryOffset(this.entity);
            return point;
        }

        @Override
        public void onRemove() {
            super.onRemove();
            PlayerData data = PlayerData.getPlayerData(this.entity);
            data.setUnknownLastClicked();
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.entityUUID = new UUID(compound.func_74763_f("UUIDMost"), compound.func_74763_f("UUIDLeast"));
        }

        @Override
        protected boolean shouldDisconnect() {
            return this.entity != null && this.entity.field_70128_L || this.forceRemove;
        }

        @Override
        public void update(Point3f from) {
            this.shouldRecalculateCatenary = true;
            super.update(from);
            if (this.entity == null) {
                List nearEntities = TileEntityFairyLightsFastener.this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)TileEntityFairyLightsFastener.this.field_145851_c, (double)TileEntityFairyLightsFastener.this.field_145848_d, (double)TileEntityFairyLightsFastener.this.field_145849_e, (double)(TileEntityFairyLightsFastener.this.field_145851_c + 1), (double)(TileEntityFairyLightsFastener.this.field_145848_d + 1), (double)(TileEntityFairyLightsFastener.this.field_145849_e + 1)).func_72314_b(20.0, 20.0, 20.0));
                for (EntityPlayer entity : nearEntities) {
                    if (!entity.func_110124_au().equals(this.entityUUID) && !UUID.nameUUIDFromBytes(("OfflinePlayer:" + entity.func_146103_bH().getName()).getBytes(Charsets.UTF_8)).equals(this.entityUUID)) continue;
                    this.entity = entity;
                    PlayerData data = PlayerData.getPlayerData(entity);
                    data.setLastClicked(TileEntityFairyLightsFastener.this.field_145851_c, TileEntityFairyLightsFastener.this.field_145848_d, TileEntityFairyLightsFastener.this.field_145849_e);
                    return;
                }
            } else {
                PlayerData data = PlayerData.getPlayerData(this.entity);
                Point3i point = data.getLastClicked();
                if (this.details == null) {
                    this.details = new NBTTagCompound();
                    this.writeDetailsToNBT(this.details);
                }
                if (point.x != TileEntityFairyLightsFastener.this.field_145851_c || point.y != TileEntityFairyLightsFastener.this.field_145848_d || point.z != TileEntityFairyLightsFastener.this.field_145849_e || this.entity.func_70694_bm() == null || this.entity.func_70694_bm().func_77942_o() && !this.entity.func_70694_bm().func_77978_p().equals((Object)this.details)) {
                    this.forceRemove = true;
                }
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            super.writeToNBT(compound);
            compound.func_74772_a("UUIDMost", this.entityUUID.getMostSignificantBits());
            compound.func_74772_a("UUIDLeast", this.entityUUID.getLeastSignificantBits());
        }
    }

    public class FastenerConnection
    extends Connection {
        private int x;
        private int y;
        private int z;

        private FastenerConnection(World worldObj) {
            super(worldObj);
        }

        public FastenerConnection(World worldObj, int x, int y, int z, boolean isOrigin, NBTTagCompound tagCompound) {
            super(worldObj, isOrigin, tagCompound);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public Point3f getTo() {
            Block toBlock = TileEntityFairyLightsFastener.this.field_145850_b.func_147439_a(this.x, this.y, this.z);
            if (!(toBlock instanceof BlockFairyLightsFastener)) {
                return null;
            }
            Point3f point = ((BlockFairyLightsFastener)toBlock).getOffsetForData(TileEntityFairyLightsFastener.this.field_145850_b.func_72805_g(this.x, this.y, this.z), 0.125f);
            point.x += (float)this.x;
            point.y += (float)this.y;
            point.z += (float)this.z;
            return point;
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.x = compound.func_74762_e("x");
            this.y = compound.func_74762_e("y");
            this.z = compound.func_74762_e("z");
        }

        @Override
        protected boolean shouldDisconnect() {
            return !(TileEntityFairyLightsFastener.this.field_145850_b.func_147438_o(this.x, this.y, this.z) instanceof TileEntityFairyLightsFastener);
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            super.writeToNBT(compound);
            compound.func_74768_a("x", this.x);
            compound.func_74768_a("y", this.y);
            compound.func_74768_a("z", this.z);
        }
    }

    public abstract class Connection {
        private World worldObj;
        private boolean isOrigin;
        private Catenary catenary;
        private Catenary prevCatenary;
        private Light[] lightPoints;
        private Light[] prevLightPoints;
        private List<Byte> pattern;
        private boolean twinkle;
        private boolean tight;
        protected boolean shouldRecalculateCatenary;
        public JinglePlayer jinglePlayer;

        private Connection(World worldObj) {
            this(worldObj, false, null);
        }

        public Connection(World worldObj, boolean isOrigin, NBTTagCompound tagCompound) {
            this.worldObj = worldObj;
            this.isOrigin = isOrigin;
            this.twinkle = false;
            this.tight = false;
            this.shouldRecalculateCatenary = true;
            this.pattern = new ArrayList<Byte>();
            if (tagCompound != null) {
                this.readDetailsFromNBT(tagCompound);
            }
        }

        public Catenary getCatenary() {
            return this.catenary;
        }

        public Light[] getLightPoints() {
            return this.lightPoints;
        }

        public List<Byte> getPattern() {
            return this.pattern;
        }

        public Catenary getPrevCatenary() {
            return this.prevCatenary;
        }

        public Light[] getPrevLightPoints() {
            return this.prevLightPoints;
        }

        public abstract Point3f getTo();

        public World getWorldObj() {
            return this.worldObj;
        }

        public boolean isOrigin() {
            return this.isOrigin;
        }

        public boolean isTight() {
            return this.tight;
        }

        public void onRemove() {
        }

        public void readDetailsFromNBT(NBTTagCompound compound) {
            NBTTagList tagList = compound.func_150295_c("pattern", 10);
            this.pattern = new ArrayList<Byte>();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.pattern.add(tagList.func_150305_b(i).func_74771_c("color"));
            }
            this.twinkle = compound.func_74767_n("twinkle");
            this.tight = compound.func_74767_n("tight");
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.isOrigin = compound.func_74767_n("isOrigin");
            this.readDetailsFromNBT(compound);
        }

        public void setJinglePlayer(JinglePlayer jinglePlayer) {
            if (this.jinglePlayer == null) {
                this.jinglePlayer = jinglePlayer;
            }
        }

        public void setPatern(List<Byte> pattern) {
            this.pattern = pattern;
        }

        protected abstract boolean shouldDisconnect();

        public void update(Point3f from) {
            this.prevCatenary = this.catenary;
            this.prevLightPoints = this.lightPoints;
            if (this.shouldRecalculateCatenary) {
                Point3f to = this.getTo();
                if (to == null) {
                    return;
                }
                to.sub(from);
                if (to.x == 0.0f && to.y == 0.0f && to.z == 0.0f) {
                    return;
                }
                this.catenary = Catenary.from(new Vector3f(to), this.tight);
                this.updateLightVertices();
                this.shouldRecalculateCatenary = false;
            }
            this.updateLights();
        }

        public void updateLights() {
            if (this.lightPoints != null) {
                for (int i = 0; i < this.lightPoints.length; ++i) {
                    Light light = this.lightPoints[i];
                    if (this.pattern.size() > 0) {
                        light.setColor(new Vector3f(EntitySheep.field_70898_d[BlockColored.func_150032_b((int)this.pattern.get(i % this.pattern.size()).byteValue())]));
                    }
                    light.tick(this, this.twinkle);
                    if (this.jinglePlayer == null || !this.worldObj.field_72995_K) continue;
                    this.jinglePlayer.play(i, TileEntityFairyLightsFastener.this.getConnectionPoint(), light);
                }
                if (this.jinglePlayer != null) {
                    this.jinglePlayer.tick();
                    if (this.jinglePlayer.isDone()) {
                        this.jinglePlayer = null;
                    }
                }
            }
        }

        private void updateLightVertices() {
            if (this.catenary != null) {
                float spacing = 16.0f;
                float totalLength = this.catenary.getLength();
                float distance = (totalLength % spacing + spacing) / 2.0f;
                Segment[] segments = this.catenary.getSegments();
                this.lightPoints = new Light[(int)(totalLength / spacing)];
                int lightIndex = 0;
                for (Segment segment : segments) {
                    float length = segment.getLength();
                    while (distance < length) {
                        Light light = new Light(segment.pointAt(distance / length));
                        light.setRotation(segment.getRotation());
                        this.lightPoints[lightIndex++] = light;
                        distance += spacing;
                    }
                    distance -= length;
                }
            }
        }

        public void writeDetailsToNBT(NBTTagCompound compound) {
            NBTTagList tagList = new NBTTagList();
            for (Byte b : this.pattern) {
                NBTTagCompound patternCompound = new NBTTagCompound();
                patternCompound.func_74774_a("color", b.byteValue());
                tagList.func_74742_a((NBTBase)patternCompound);
            }
            if (tagList.func_74745_c() > 0) {
                compound.func_74782_a("pattern", (NBTBase)tagList);
            }
            compound.func_74757_a("twinkle", this.twinkle);
            compound.func_74757_a("tight", this.tight);
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74757_a("isOrigin", this.isOrigin);
            this.writeDetailsToNBT(compound);
        }
    }
}

