/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.player;

import com.pau101.fairylights.util.vectormath.Point3i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PlayerData {
    private static Map<EntityPlayer, PlayerData> playerMap = new HashMap<EntityPlayer, PlayerData>();
    private static final Point3i UNKNOWN = new Point3i();
    private Point3i lastClicked;

    public static PlayerData getPlayerData(EntityPlayer player) {
        PlayerData data = playerMap.get(player);
        if (data == null && player != null) {
            data = new PlayerData();
            playerMap.put(player, data);
        }
        return data;
    }

    public static void takeOutTheGarbage(World world) {
        Iterator<EntityPlayer> playerIterator = playerMap.keySet().iterator();
        ArrayList<EntityPlayer> removeList = new ArrayList<EntityPlayer>();
        while (playerIterator.hasNext()) {
            EntityPlayer player = playerIterator.next();
            if (world.field_73010_i.contains(player) || player.field_70170_p != world) continue;
            removeList.add(player);
        }
        playerMap.keySet().removeAll(removeList);
    }

    public static void update() {
        for (Map.Entry<EntityPlayer, PlayerData> dataEntry : playerMap.entrySet()) {
            Point3i lastClicked = dataEntry.getValue().lastClicked;
            if (dataEntry.getKey().field_70170_p.func_147438_o(lastClicked.x, lastClicked.y, lastClicked.z) != null) continue;
            dataEntry.getValue().lastClicked = UNKNOWN;
        }
    }

    public PlayerData() {
        this.setUnknownLastClicked();
    }

    public Point3i getLastClicked() {
        return this.lastClicked;
    }

    public boolean hasLastClicked() {
        return this.lastClicked != UNKNOWN;
    }

    public void setLastClicked(int x, int y, int z) {
        this.lastClicked = new Point3i(x, y, z);
    }

    public void setUnknownLastClicked() {
        this.lastClicked = UNKNOWN;
    }
}

