/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.network;

import com.google.common.collect.HashBiMap;
import com.pau101.fairylights.network.FLPacket;
import com.pau101.fairylights.network.play.server.S00FLPacketJingle;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FLNetworkManager {
    private static final Logger logger = LogManager.getLogger();
    public static HashBiMap<Integer, Class<? extends FLPacket>> packetMap = HashBiMap.create();
    private String channelName;
    private FMLEventChannel channel;

    public FLNetworkManager(String channelName) {
        this.channelName = channelName;
        this.channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        this.channel.register((Object)this);
    }

    private FMLProxyPacket getInProxy(FLPacket modPacket) {
        int id = (Integer)packetMap.inverse().get(modPacket.getClass());
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(id);
        modPacket.writePacketData(packetBuffer);
        FMLProxyPacket packet = new FMLProxyPacket((ByteBuf)packetBuffer, this.channelName);
        return packet;
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent e) throws IOException {
        this.processPacket((FMLNetworkEvent.CustomPacketEvent)e);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent e) throws IOException {
        this.processPacket((FMLNetworkEvent.CustomPacketEvent)e);
    }

    private void processPacket(FMLNetworkEvent.CustomPacketEvent e) throws IOException {
        ByteBuf byteBuf;
        int readableBytes;
        FMLProxyPacket proxyPacket = e.packet;
        if (this.channelName.equals(proxyPacket.channel()) && (readableBytes = (byteBuf = proxyPacket.payload()).readableBytes()) != 0) {
            PacketBuffer packetBuffer = new PacketBuffer(byteBuf);
            int id = packetBuffer.func_150792_a();
            FLPacket packet = FLPacket.generatePacket(packetMap, id);
            if (packet == null) {
                logger.warn("Bad Packet id " + id);
            } else {
                packet.readPacketData(packetBuffer);
                packet.processPacket(e.handler);
            }
        }
    }

    public void sendPacketToClient(FLPacket modPacket, EntityPlayerMP player) {
        this.channel.sendTo(this.getInProxy(modPacket), player);
    }

    public void sendPacketToClientsWatchingChunk(int x, int z, World world, FLPacket packet, Entity ... exceptions) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
            boolean found = false;
            if (exceptions != null) {
                for (Entity e : exceptions) {
                    if (e != player) continue;
                    found = true;
                }
            }
            if (found || player.field_70170_p != world || !player.func_71121_q().func_73040_p().func_72694_a(player, chunkX, chunkZ)) continue;
            this.sendPacketToClient(packet, player);
        }
    }

    public void sendPacketToServer(FLPacket modPacket) {
        this.channel.sendToServer(this.getInProxy(modPacket));
    }

    static {
        packetMap.put((Object)0, S00FLPacketJingle.class);
    }
}

