/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.renderer.item;

import com.pau101.fairylights.item.ItemFairyLights;
import com.pau101.fairylights.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRendererFairyLights
implements IItemRenderer {
    private RenderItem renderItem;
    private ItemRenderer itemRenderer;
    private int[][] lightLocations;
    private Minecraft mc;
    private Tessellator tessellator;
    private float[] defaultColor = new float[]{1.0156863f, 0.94666666f, 0.5176471f};
    private Random random;

    public static List<Byte> getByteList(NBTTagList tagList) {
        ArrayList<Byte> pattern = new ArrayList<Byte>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            pattern.add(tagList.func_150305_b(i).func_74771_c("color"));
        }
        return pattern;
    }

    public ItemRendererFairyLights() {
        this.lightLocations = new int[][]{{1, 11}, {7, 9}, {5, 3}, {11, 1}};
        this.mc = Minecraft.func_71410_x();
        this.tessellator = Tessellator.field_78398_a;
        this.renderItem = new RenderItem();
        this.itemRenderer = new ItemRenderer(this.mc);
        this.random = new Random();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public void renderIcon(double x, double y, IIcon icon, double width, double height) {
        this.tessellator.func_78382_b();
        this.tessellator.func_78374_a(x, y + height, (double)this.renderItem.field_77023_b, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        this.tessellator.func_78374_a(x + width, y + height, (double)this.renderItem.field_77023_b, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        this.tessellator.func_78374_a(x + width, y, (double)this.renderItem.field_77023_b, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        this.tessellator.func_78374_a(x, y, (double)this.renderItem.field_77023_b, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        this.tessellator.func_78381_a();
    }

    public void renderIcon3D(double x, double y, IIcon icon, double width, double height) {
        this.tessellator.func_78382_b();
        this.tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.tessellator.func_78374_a(x, y + height, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        this.tessellator.func_78374_a(x + width, y + height, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        this.tessellator.func_78374_a(x + width, y, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        this.tessellator.func_78374_a(x, y, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        this.tessellator.func_78381_a();
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        NBTTagCompound tagCompound = item.func_77978_p();
        List<Byte> pattern = null;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (tagCompound != null && (pattern = ItemRendererFairyLights.getByteList(tagCompound.func_150295_c("pattern", 10))).size() > 0) {
                this.renderIcon(0.0, 0.0, ItemFairyLights.cordIcon, 16.0, 16.0);
                for (int i = 0; i < this.lightLocations.length; ++i) {
                    int[] location = this.lightLocations[i];
                    float[] color = EntitySheep.field_70898_d[BlockColored.func_150032_b((int)pattern.get(i % pattern.size()).byteValue())];
                    GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
                    this.renderIcon(location[0], location[1], ItemFairyLights.lightIcon, 16.0, 16.0);
                }
            } else {
                this.renderItem.func_94149_a(0, 0, item.func_77954_c(), 16, 16);
            }
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.random.setSeed(187L);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            EntityItem entityItem = (EntityItem)data[1];
            float verticalOscillation = MathHelper.func_76126_a((float)(((float)entityItem.field_70292_b + (RenderItem.field_82407_g ? 0.0f : ClientProxy.mcTimer.field_74281_c)) / 10.0f + entityItem.field_70290_d)) * 0.1f + 0.1f;
            GL11.glTranslatef((float)0.0f, (float)verticalOscillation, (float)0.0f);
            if (RenderItem.field_82407_g) {
                GL11.glScalef((float)0.5128205f, (float)0.5128205f, (float)0.5128205f);
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
            } else {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            float f6 = 1.0f;
            float f7 = 0.5f;
            float f8 = 0.25f;
            if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
                GL11.glPushMatrix();
                if (RenderItem.field_82407_g) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glRotatef((float)((((float)entityItem.field_70292_b + ClientProxy.mcTimer.field_74281_c) / 20.0f + entityItem.field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                float sixteenth = 0.0625f;
                float magicNumber = 0.021875f;
                ItemStack itemStack = entityItem.func_92059_d();
                int stackSize = itemStack.field_77994_a;
                int count = stackSize < 2 ? 1 : (stackSize < 16 ? 2 : (stackSize < 32 ? 3 : 4));
                GL11.glTranslatef((float)(-f7), (float)(-f8), (float)(-((sixteenth + magicNumber) * (float)count / 2.0f)));
                for (int k = 0; k < count; ++k) {
                    if (k > 0) {
                        float x = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                        float y = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                        float z = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                        GL11.glTranslatef((float)x, (float)y, (float)(sixteenth + magicNumber));
                    } else {
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(sixteenth + magicNumber));
                    }
                    GL11.glDisable((int)2884);
                    GL11.glTranslatef((float)1.0f, (float)0.0f, (float)-0.0625f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    ItemRenderer.func_78439_a((Tessellator)this.tessellator, (float)ItemFairyLights.cordIcon.func_94209_e(), (float)ItemFairyLights.cordIcon.func_94206_g(), (float)ItemFairyLights.cordIcon.func_94212_f(), (float)ItemFairyLights.cordIcon.func_94210_h(), (int)ItemFairyLights.cordIcon.func_94211_a(), (int)ItemFairyLights.cordIcon.func_94216_b(), (float)0.0625f);
                    if (tagCompound != null) {
                        pattern = ItemRendererFairyLights.getByteList(tagCompound.func_150295_c("pattern", 10));
                    }
                    for (int i = 0; i < this.lightLocations.length; ++i) {
                        int[] location = this.lightLocations[i];
                        float[] color = pattern == null || pattern.size() == 0 ? this.defaultColor : EntitySheep.field_70898_d[BlockColored.func_150032_b((int)pattern.get(i % pattern.size()).byteValue())];
                        GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
                        GL11.glPushMatrix();
                        float scale = 1.05f;
                        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                        GL11.glTranslatef((float)(location[0] + 2), (float)(16 - location[1] - 2), (float)((scale - 1.0f) / 2.0f));
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glTranslatef((float)-2.0f, (float)-14.0f, (float)0.0f);
                        GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
                        ItemRenderer.func_78439_a((Tessellator)this.tessellator, (float)ItemFairyLights.lightIcon.func_94209_e(), (float)ItemFairyLights.lightIcon.func_94206_g(), (float)ItemFairyLights.lightIcon.func_94212_f(), (float)ItemFairyLights.lightIcon.func_94210_h(), (int)ItemFairyLights.lightIcon.func_94211_a(), (int)ItemFairyLights.lightIcon.func_94216_b(), (float)0.0625f);
                        GL11.glPopMatrix();
                    }
                    GL11.glEnable((int)2884);
                }
                GL11.glPopMatrix();
            } else {
                ItemStack itemstack = entityItem.func_92059_d();
                int stackSize = itemstack.field_77994_a;
                int count = 1;
                if (stackSize > 1) {
                    count = 2;
                } else if (stackSize > 5) {
                    count = 3;
                } else if (stackSize > 20) {
                    count = 4;
                } else if (stackSize > 40) {
                    count = 5;
                }
                for (int l = 0; l < count; ++l) {
                    GL11.glPushMatrix();
                    if (l > 0) {
                        float x = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        float y = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        float z = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        GL11.glTranslatef((float)x, (float)y, (float)z);
                    }
                    if (!RenderItem.field_82407_g) {
                        GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glScalef((float)0.0625f, (float)-0.0625f, (float)0.0625f);
                    GL11.glTranslatef((float)-8.0f, (float)-12.0f, (float)0.0f);
                    if (tagCompound != null && (pattern = ItemRendererFairyLights.getByteList(tagCompound.func_150295_c("pattern", 10))).size() > 0) {
                        this.renderIcon3D(0.0, 0.0, ItemFairyLights.cordIcon, 16.0, 16.0);
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.25f);
                        for (int i = 0; i < this.lightLocations.length; ++i) {
                            int[] location = this.lightLocations[i];
                            float[] color = EntitySheep.field_70898_d[BlockColored.func_150032_b((int)pattern.get(i % pattern.size()).byteValue())];
                            GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
                            this.renderIcon3D(location[0], location[1], ItemFairyLights.lightIcon, 16.0, 16.0);
                        }
                    } else {
                        this.renderIcon3D(0.0, 0.0, item.func_77954_c(), 16.0, 16.0);
                    }
                    GL11.glPopMatrix();
                }
            }
        } else {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0625f);
            GL11.glDisable((int)2884);
            ItemRenderer.func_78439_a((Tessellator)this.tessellator, (float)ItemFairyLights.cordIcon.func_94209_e(), (float)ItemFairyLights.cordIcon.func_94206_g(), (float)ItemFairyLights.cordIcon.func_94212_f(), (float)ItemFairyLights.cordIcon.func_94210_h(), (int)ItemFairyLights.cordIcon.func_94211_a(), (int)ItemFairyLights.cordIcon.func_94216_b(), (float)0.0625f);
            if (tagCompound != null) {
                pattern = ItemRendererFairyLights.getByteList(tagCompound.func_150295_c("pattern", 10));
            }
            for (int i = 0; i < this.lightLocations.length; ++i) {
                int[] location = this.lightLocations[i];
                float[] color = pattern == null || pattern.size() == 0 ? this.defaultColor : EntitySheep.field_70898_d[BlockColored.func_150032_b((int)pattern.get(i % pattern.size()).byteValue())];
                GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
                GL11.glPushMatrix();
                float scale = 1.05f;
                GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GL11.glTranslatef((float)(location[0] + 2), (float)(16 - location[1] - 2), (float)((scale - 1.0f) / 2.0f));
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glTranslatef((float)-2.0f, (float)-14.0f, (float)0.0f);
                GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
                ItemRenderer.func_78439_a((Tessellator)this.tessellator, (float)ItemFairyLights.lightIcon.func_94209_e(), (float)ItemFairyLights.lightIcon.func_94206_g(), (float)ItemFairyLights.lightIcon.func_94212_f(), (float)ItemFairyLights.lightIcon.func_94210_h(), (int)ItemFairyLights.lightIcon.func_94211_a(), (int)ItemFairyLights.lightIcon.func_94216_b(), (float)0.0625f);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)2884);
        }
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }
}

