/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOxygenCollector
extends TileEntityOxygen
implements IInventory,
ISidedInventory {
    public boolean active;
    public static final int OUTPUT_PER_TICK = 100;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float lastOxygenCollected;
    private ItemStack[] containingItems = new ItemStack[1];
    private boolean noAtmosphericOxygen = true;
    private boolean isInitialised = false;
    private boolean producedLastTick = false;

    public TileEntityOxygenCollector() {
        super(6000.0f, 0.0f);
        this.noRedstoneControl = true;
    }

    @Override
    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor((double)this.storedOxygen / (double)this.maxOxygen * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.producedLastTick = this.storedOxygen < this.maxOxygen;
            this.produceOxygen();
            if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                if (this.hasEnoughEnergyToRun) {
                    float nearbyLeaves = 0.0f;
                    if (!this.isInitialised) {
                        this.noAtmosphericOxygen = this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider && !((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).isGasPresent(IAtmosphericGas.OXYGEN);
                        this.isInitialised = true;
                    }
                    if (this.noAtmosphericOxygen) {
                        if (this.field_145851_c > -29999995 && this.field_145851_c < 2999995 && this.field_145849_e > -29999995 && this.field_145849_e < 29999995) {
                            int miny = this.field_145848_d - 5;
                            int maxy = this.field_145848_d + 5;
                            if (miny < 0) {
                                miny = 0;
                            }
                            if (maxy >= this.field_145850_b.func_72800_K()) {
                                maxy = this.field_145850_b.func_72800_K() - 1;
                            }
                            for (int x = this.field_145851_c - 5; x <= this.field_145851_c + 5; ++x) {
                                int chunkx = x >> 4;
                                int intrachunkx = x & 0xF;
                                int chunkz = this.field_145849_e - 5 >> 4;
                                Chunk chunk = this.field_145850_b.func_72964_e(chunkx, chunkz);
                                for (int z = this.field_145849_e - 5; z <= this.field_145849_e + 5; ++z) {
                                    if (z >> 4 != chunkz) {
                                        chunkz = z >> 4;
                                        chunk = this.field_145850_b.func_72964_e(chunkx, chunkz);
                                    }
                                    for (int y = miny; y <= maxy; ++y) {
                                        Block block = chunk.func_150810_a(intrachunkx, y, z & 0xF);
                                        if (block instanceof BlockAir || !block.isLeaves((IBlockAccess)this.field_145850_b, x, y, z) && (!(block instanceof IPlantable) || ((IPlantable)block).getPlantType((IBlockAccess)this.field_145850_b, x, y, z) != EnumPlantType.Crop)) continue;
                                        nearbyLeaves += 0.75f;
                                    }
                                }
                            }
                        }
                    } else {
                        nearbyLeaves = 93.0f;
                    }
                    nearbyLeaves = (float)Math.floor(nearbyLeaves);
                    this.lastOxygenCollected = nearbyLeaves / 10.0f;
                    this.storedOxygen = (int)Math.max(Math.min(this.storedOxygen + nearbyLeaves, this.maxOxygen), 0.0f);
                } else {
                    this.lastOxygenCollected = 0.0f;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.oxygencollector.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.storedOxygen > 0.0f && this.producedLastTick;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() + 2));
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public boolean shouldPullOxygen() {
        return false;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return 0;
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.of(this.getElectricInputDirection().getOpposite());
    }

    @Override
    public float getOxygenProvide(ForgeDirection direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(500.0f, this.getOxygenStored()) : 0.0f;
    }
}

