/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFuelLoader
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandler,
ILandingPadAttachable {
    private final int tankCapacity = 12000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    private ItemStack[] containingItems = new ItemStack[2];
    public IFuelable attachedFuelable;
    private boolean loadedFuelLastTick = false;

    public TileEntityFuelLoader() {
        this.storage.setMaxExtract(30.0f);
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.loadedFuelLastTick = false;
            if (this.containingItems[1] != null) {
                if (this.containingItems[1].func_77973_b() instanceof ItemCanisterGeneric) {
                    if (this.containingItems[1].func_77973_b() == GCItems.fuelCanister) {
                        int used;
                        int originalDamage = this.containingItems[1].func_77960_j();
                        this.containingItems[1] = originalDamage + (used = this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, 1001 - originalDamage), true)) == 1001 ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(GCItems.fuelCanister, 1, originalDamage + used);
                    }
                } else {
                    int isFuel;
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1]);
                    if (liquid != null && (isFuel = (int)(FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid)) ? 1 : 0)) != 0 && (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity())) {
                        this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, liquid.amount), true);
                        if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                            int amount = this.containingItems[1].field_77994_a;
                            if (amount > 1) {
                                this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, (amount - 1) * 1000), true);
                            }
                            this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                        } else {
                            --this.containingItems[1].field_77994_a;
                            if (this.containingItems[1].field_77994_a == 0) {
                                this.containingItems[1] = null;
                            }
                        }
                    }
                }
            }
            if (this.ticks % 100L == 0L) {
                this.attachedFuelable = null;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity pad = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, dir);
                    if (pad instanceof TileEntityMulti) {
                        TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                        if (!(mainTile instanceof IFuelable)) continue;
                        this.attachedFuelable = (IFuelable)mainTile;
                        break;
                    }
                    if (!(pad instanceof IFuelable)) continue;
                    this.attachedFuelable = (IFuelable)pad;
                    break;
                }
            }
            if (this.fuelTank != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().amount > 0) {
                FluidStack liquid = new FluidStack(GalacticraftCore.fluidFuel, 2);
                if (this.attachedFuelable != null && this.hasEnoughEnergyToRun && !this.disabled) {
                    int filled = this.attachedFuelable.addFuel(liquid, true);
                    this.loadedFuelLastTick = filled > 0;
                    this.fuelTank.drain(filled, true);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.fuelTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.fuelloader.name");
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1 && itemstack != null) {
            return FluidUtil.isEmptyContainer(itemstack);
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 1 && itemstack != null && itemstack.func_77973_b() == GCItems.fuelCanister || slotID == 0 && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fuelTank.getFluid() == null || this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)resource))) {
            used = this.fuelTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.fuelTank.getFluid() != null && this.fuelTank.getFluid().amount > 0 && !this.getDisabled(0) && this.loadedFuelLastTick;
    }

    @Override
    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

