/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityDungeonSpawner
extends TileEntityAdvanced {
    public Class<? extends IBoss> bossClass;
    public IBoss boss;
    public boolean spawned;
    public boolean isBossDefeated;
    public boolean playerInRange;
    public boolean lastPlayerInRange;
    public boolean playerCheated;
    private Vector3 roomCoords;
    private Vector3 roomSize;

    public TileEntityDungeonSpawner() {
        this(EntitySkeletonBoss.class);
    }

    public TileEntityDungeonSpawner(Class<? extends IBoss> bossClass) {
        this.bossClass = bossClass;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.roomCoords == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            Vector3 thisVec = new Vector3(this);
            List l = this.field_145850_b.func_72872_a(this.bossClass, AxisAlignedBB.func_72330_a((double)(thisVec.x - 15.0), (double)(thisVec.y - 15.0), (double)(thisVec.z - 15.0), (double)(thisVec.x + 15.0), (double)(thisVec.y + 15.0), (double)(thisVec.z + 15.0)));
            for (Object e : l) {
                if (((Entity)e).field_70128_L) continue;
                this.boss = (IBoss)e;
                this.boss.setRoom(this.roomCoords, this.roomSize);
                this.spawned = true;
                this.isBossDefeated = false;
            }
            List entitiesWithin = this.field_145850_b.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 4), (double)(this.roomCoords.intY() - 4), (double)(this.roomCoords.intZ() - 4), (double)(this.roomCoords.intX() + this.roomSize.intX() + 3), (double)(this.roomCoords.intY() + this.roomSize.intY() + 3), (double)(this.roomCoords.intZ() + this.roomSize.intZ() + 3)));
            for (Entity mob : entitiesWithin) {
                if (!this.getDisabledCreatures().contains(mob.getClass())) continue;
                mob.func_70106_y();
            }
            if (this.boss == null && !this.isBossDefeated) {
                try {
                    Constructor<? extends IBoss> c = this.bossClass.getConstructor(World.class);
                    this.boss = c.newInstance(this.field_145850_b);
                    ((Entity)this.boss).func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5);
                    this.boss.setRoom(this.roomCoords, this.roomSize);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            entitiesWithin = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 1), (double)(this.roomCoords.intY() - 1), (double)(this.roomCoords.intZ() - 1), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ())));
            if (this.playerCheated && !entitiesWithin.isEmpty()) {
                this.isBossDefeated = false;
                this.spawned = false;
                this.lastPlayerInRange = false;
                this.playerCheated = false;
            }
            boolean bl = this.playerInRange = !entitiesWithin.isEmpty();
            if (this.playerInRange && !this.lastPlayerInRange && this.boss != null && !this.spawned && this.boss instanceof Entity) {
                this.field_145850_b.func_72838_d((Entity)((EntityLiving)this.boss));
                this.playSpawnSound((Entity)this.boss);
                this.spawned = true;
                this.boss.onBossSpawned(this);
                this.boss.setRoom(this.roomCoords, this.roomSize);
            }
            this.lastPlayerInRange = this.playerInRange;
        }
    }

    public void playSpawnSound(Entity entity) {
    }

    public List<Class<? extends EntityLiving>> getDisabledCreatures() {
        ArrayList<Class<? extends EntityLiving>> list = new ArrayList<Class<? extends EntityLiving>>();
        list.add(EntityEvolvedSkeleton.class);
        list.add(EntityEvolvedCreeper.class);
        list.add(EntityEvolvedZombie.class);
        list.add(EntityEvolvedSpider.class);
        return list;
    }

    public void setRoom(Vector3 coords, Vector3 size) {
        this.roomCoords = coords;
        this.roomSize = size;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.spawned = nbt.func_74767_n("spawned");
        this.playerInRange = this.lastPlayerInRange = nbt.func_74767_n("playerInRange");
        this.isBossDefeated = nbt.func_74767_n("defeated");
        this.playerCheated = nbt.func_74767_n("playerCheated");
        try {
            this.bossClass = Class.forName(nbt.func_74779_i("bossClass"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.roomCoords = new Vector3();
        this.roomCoords.x = nbt.func_74769_h("roomCoordsX");
        this.roomCoords.y = nbt.func_74769_h("roomCoordsY");
        this.roomCoords.z = nbt.func_74769_h("roomCoordsZ");
        this.roomSize = new Vector3();
        this.roomSize.x = nbt.func_74769_h("roomSizeX");
        this.roomSize.y = nbt.func_74769_h("roomSizeY");
        this.roomSize.z = nbt.func_74769_h("roomSizeZ");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("spawned", this.spawned);
        nbt.func_74757_a("playerInRange", this.playerInRange);
        nbt.func_74757_a("defeated", this.isBossDefeated);
        nbt.func_74757_a("playerCheated", this.playerCheated);
        nbt.func_74778_a("bossClass", this.bossClass.getCanonicalName());
        if (this.roomCoords != null) {
            nbt.func_74780_a("roomCoordsX", this.roomCoords.x);
            nbt.func_74780_a("roomCoordsY", this.roomCoords.y);
            nbt.func_74780_a("roomCoordsZ", this.roomCoords.z);
            nbt.func_74780_a("roomSizeX", this.roomSize.x);
            nbt.func_74780_a("roomSizeY", this.roomSize.y);
            nbt.func_74780_a("roomSizeZ", this.roomSize.z);
        }
    }

    @Override
    public double getPacketRange() {
        return 0.0;
    }

    @Override
    public int getPacketCooldown() {
        return 0;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }
}

