/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.item.IKeyItem;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOverworld;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandlerGC {
    public static Map<Block, Item> bucketList = new HashMap<Block, Item>();
    public static boolean bedActivated;
    private List<SoundPlayEntry> soundPlayList = new ArrayList<SoundPlayEntry>();

    @SubscribeEvent
    public void onRocketLaunch(EntitySpaceshipBase.RocketLaunchEvent event) {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equals("GalacticraftCore")) {
            ConfigManagerCore.syncConfig(false);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ChunkLoadingCallback.save((WorldServer)event.world);
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoadingCallback.load((WorldServer)event.world);
    }

    @SubscribeEvent
    public void onWorldLoad(ChunkEvent.Load event) {
        if (!event.world.field_72995_K) {
            ChunkLoadingCallback.load((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        if (event.source.field_76373_n.equals(DamageSource.field_76370_b.field_76373_n) && OxygenUtil.noAtmosphericCombustion(event.entityLiving.field_70170_p.field_73011_w)) {
            if (OxygenUtil.isAABBInBreathableAirBlock(event.entityLiving.field_70170_p, event.entityLiving.field_70121_D)) {
                return;
            }
            if (event.entityLiving.field_70170_p instanceof WorldServer) {
                ((WorldServer)event.entityLiving.field_70170_p).func_147487_a("smoke", event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + event.entityLiving.field_70121_D.field_72337_e - event.entityLiving.field_70121_D.field_72338_b, event.entityLiving.field_70161_v, 50, 0.0, 0.05, 0.0, 0.001);
            }
            event.entityLiving.func_70066_B();
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.field_70154_o instanceof EntityAutoRocket || player.field_70154_o instanceof EntityLanderBase) {
                event.distance = 0.0f;
                event.setCanceled(true);
                return;
            }
        }
        if (event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            event.distance *= ((IGalacticraftWorldProvider)event.entityLiving.field_70170_p.field_73011_w).getFallDamageModifier();
        }
    }

    @SubscribeEvent
    public void onPlayerClicked(PlayerInteractEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_71071_by == null) {
            return;
        }
        World worldObj = event.entityPlayer.field_70170_p;
        if (worldObj == null) {
            return;
        }
        Block idClicked = worldObj.func_147439_a(event.x, event.y, event.z);
        if (idClicked == Blocks.field_150324_C && worldObj.field_73011_w instanceof IGalacticraftWorldProvider && event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && !worldObj.field_72995_K && !((IGalacticraftWorldProvider)worldObj.field_73011_w).hasBreathableAtmosphere()) {
            if (GalacticraftCore.isPlanetsLoaded) {
                GCPlayerStats.tryBedWarning((EntityPlayerMP)event.entityPlayer);
            }
            if (worldObj.field_73011_w instanceof WorldProviderOrbit) {
                event.setCanceled(true);
                return;
            }
            bedActivated = true;
            if (worldObj.field_73011_w.func_76567_e() && !bedActivated) {
                bedActivated = true;
                event.entityPlayer.func_71063_a(new ChunkCoordinates(event.x, event.y, event.z), false);
            } else {
                bedActivated = false;
            }
        }
        ItemStack heldStack = event.entityPlayer.field_71071_by.func_70448_g();
        TileEntity tileClicked = worldObj.func_147438_o(event.x, event.y, event.z);
        if (heldStack != null) {
            if (tileClicked != null && tileClicked instanceof IKeyable) {
                if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                    event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                    return;
                }
                if (event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
                    if (heldStack.func_77973_b() instanceof IKeyItem) {
                        if (((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == -1 || ((IKeyable)tileClicked).getTierOfKeyRequired() == -1 || ((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == ((IKeyable)tileClicked).getTierOfKeyRequired()) {
                            event.setCanceled(((IKeyable)tileClicked).onValidKeyActivated(event.entityPlayer, heldStack, event.face));
                        } else {
                            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                        }
                    } else {
                        event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                    }
                }
            }
            if ((heldStack.func_77973_b() instanceof ItemFlintAndSteel || heldStack.func_77973_b() instanceof ItemFireball) && !worldObj.field_72995_K && event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && idClicked != Blocks.field_150335_W && OxygenUtil.noAtmosphericCombustion(worldObj.field_73011_w) && !OxygenUtil.isAABBInBreathableAirBlock(worldObj, AxisAlignedBB.func_72330_a((double)event.x, (double)event.y, (double)event.z, (double)(event.x + 1), (double)(event.y + 2), (double)(event.z + 1)))) {
                event.setCanceled(true);
            }
        } else if (tileClicked != null && tileClicked instanceof IKeyable) {
            if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                return;
            }
            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
        }
    }

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.entityLiving;
        if (entityLiving instanceof EntityPlayerMP) {
            GalacticraftCore.handler.onPlayerUpdate((EntityPlayerMP)entityLiving);
            if (GalacticraftCore.isPlanetsLoaded) {
                AsteroidsModule.playerHandler.onPlayerUpdate((EntityPlayerMP)entityLiving);
            }
            return;
        }
        if (!(entityLiving.field_70173_aa % 100 != 0 || !(entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) || entityLiving instanceof EntityPlayer || entityLiving instanceof IEntityBreathable && ((IEntityBreathable)entityLiving).canBreath() || ((IGalacticraftWorldProvider)entityLiving.field_70170_p.field_73011_w).hasBreathableAtmosphere())) {
            if (ConfigManagerCore.challengeMode && entityLiving instanceof EntityEnderman) {
                return;
            }
            if (!OxygenUtil.isAABBInBreathableAirBlock(entityLiving)) {
                GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre(entityLiving);
                MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
                if (suffocationEvent.isCanceled()) {
                    return;
                }
                entityLiving.func_70097_a((DamageSource)DamageSourceGC.oxygenSuffocation, 1.0f);
                GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post(entityLiving);
                MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
            }
        }
    }

    private ItemStack fillBucket(World world, MovingObjectPosition position) {
        Block block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
        Item bucket = bucketList.get(block);
        if (bucket != null && world.func_72805_g(position.field_72311_b, position.field_72312_c, position.field_72309_d) == 0) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(bucket);
        }
        return null;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        MovingObjectPosition pos = event.target;
        ItemStack ret = this.fillBucket(event.world, pos);
        if (ret == null) {
            return;
        }
        event.result = ret;
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen) {
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        EventHandlerGC.generateOil(event.world, event.rand, worldX + event.rand.nextInt(16), worldZ + event.rand.nextInt(16), false);
    }

    public static boolean oilPresent(World world, Random rand, int x, int z, BlockVec3 pos) {
        boolean flag2;
        boolean doGen2 = false;
        int[] nArray = ConfigManagerCore.externalOilGen;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer dim = nArray[i];
            if (dim != world.field_73011_w.field_76574_g) continue;
            doGen2 = true;
            break;
        }
        if (!doGen2) {
            return false;
        }
        BiomeGenBase biomegenbase = world.func_72807_a(x + 8, z + 8);
        if (biomegenbase.field_76756_M == BiomeGenBase.field_76779_k.field_76756_M || biomegenbase.field_76756_M == BiomeGenBase.field_76778_j.field_76756_M) {
            return false;
        }
        rand.setSeed(world.func_72905_C());
        long i1 = (long)rand.nextInt() / 2L * 2L + 1L;
        long j1 = (long)rand.nextInt() / 2L * 2L + 1L;
        rand.setSeed((long)x * i1 + (long)z * j1 ^ world.func_72905_C());
        double randMod = Math.min(0.2, 0.08 * ConfigManagerCore.oilGenFactor);
        if (biomegenbase.field_76748_D >= 0.45f) {
            randMod /= 2.0;
        }
        if (biomegenbase.field_76748_D < -0.5f) {
            randMod *= 1.8;
        }
        if (biomegenbase instanceof BiomeGenDesert) {
            randMod *= 1.8;
        }
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            pos.y = 17 + rand.nextInt(10) + rand.nextInt(5);
            pos.x = x + rand.nextInt(16);
            pos.z = z + rand.nextInt(16);
            return true;
        }
        return false;
    }

    public static void generateOil(World world, Random rand, int xx, int zz, boolean testFirst) {
        BlockVec3 pos = new BlockVec3();
        if (EventHandlerGC.oilPresent(world, rand, xx, zz, pos)) {
            int x = pos.x;
            int cy = pos.y;
            int z = pos.z;
            int r = 3 + rand.nextInt(5);
            if (testFirst && EventHandlerGC.checkOilPresent(world, x, cy, z, r)) {
                return;
            }
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r + 2; by <= r - 2; ++by) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by * by * 3 + bz * bz;
                        if (d2 > r2 || EventHandlerGC.checkBlock(world, bx + x - 1, by + cy, bz + z) || EventHandlerGC.checkBlock(world, bx + x + 1, by + cy, bz + z) || EventHandlerGC.checkBlock(world, bx + x, by + cy - 1, bz + z) || EventHandlerGC.checkBlock(world, bx + x, by + cy, bz + z - 1) || EventHandlerGC.checkBlock(world, bx + x, by + cy, bz + z + 1) || EventHandlerGC.checkBlockAbove(world, bx + x, by + cy + 1, bz + z)) continue;
                        world.func_147465_d(bx + x, by + cy, bz + z, GCBlocks.crudeOil, 0, 2);
                    }
                }
            }
        }
    }

    private static boolean checkOilPresent(World world, int x, int cy, int z, int r) {
        int r2 = r * r;
        for (int bx = -r; bx <= r; ++bx) {
            for (int by = -r + 2; by <= r - 2; ++by) {
                for (int bz = -r; bz <= r; ++bz) {
                    int d2 = bx * bx + by * by * 3 + bz * bz;
                    if (d2 > r2 || EventHandlerGC.checkBlock(world, bx + x - 1, by + cy, bz + z) || EventHandlerGC.checkBlock(world, bx + x + 1, by + cy, bz + z) || EventHandlerGC.checkBlock(world, bx + x, by + cy - 1, bz + z) || EventHandlerGC.checkBlock(world, bx + x, by + cy, bz + z - 1) || EventHandlerGC.checkBlock(world, bx + x, by + cy, bz + z + 1) || EventHandlerGC.checkBlockAbove(world, bx + x, by + cy + 1, bz + z) || world.func_147439_a(bx + x, by + cy, bz + z) != GCBlocks.crudeOil) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void retrogenOil(World world, Chunk chunk) {
        int cx = chunk.field_76635_g;
        int cz = chunk.field_76647_h;
        EventHandlerGC.generateOil(world, new Random(), cx << 4, cz << 4, true);
    }

    private static boolean checkBlock(World w, int x, int y, int z) {
        Block b = w.func_147439_a(x, y, z);
        if (b.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        return b instanceof BlockLiquid && b != GCBlocks.crudeOil;
    }

    private static boolean checkBlockAbove(World w, int x, int y, int z) {
        Block b = w.func_147439_a(x, y, z);
        if (b instanceof BlockSand) {
            return true;
        }
        return b instanceof BlockGravel;
    }

    @SubscribeEvent
    public void schematicUnlocked(SchematicEvent.Unlock event) {
        GCPlayerStats stats = GCPlayerStats.get(event.player);
        if (!stats.unlockedSchematics.contains(event.page)) {
            stats.unlockedSchematics.add(event.page);
            Collections.sort(stats.unlockedSchematics);
            if (event.player != null && event.player.field_71135_a != null) {
                Integer[] iArray = new Integer[stats.unlockedSchematics.size()];
                for (int i = 0; i < iArray.length; ++i) {
                    ISchematicPage page = stats.unlockedSchematics.get(i);
                    iArray[i] = page == null ? -2 : page.getPageID();
                }
                ArrayList<Object> objList = new ArrayList<Object>();
                objList.add(iArray);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, objList), event.player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void schematicFlipEvent(SchematicEvent.FlipPage event) {
        ISchematicPage page = null;
        switch (event.direction) {
            case 1: {
                page = EventHandlerGC.getNextSchematic(event.index);
                break;
            }
            case -1: {
                page = EventHandlerGC.getLastSchematic(event.index);
            }
        }
        if (page != null) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_OPEN_SCHEMATIC_PAGE, new Object[]{page.getPageID()}));
            FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)GalacticraftCore.instance, page.getGuiID(), FMLClientHandler.instance().getClient().field_71439_g.field_70170_p, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70165_t, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70163_u, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70161_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getNextSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        EntityClientPlayerMP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((EntityPlayerSP)player);
        for (int i = 0; i < stats.unlockedSchematics.size(); ++i) {
            idList.put(i, stats.unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count + 1 < stats.unlockedSchematics.size()) {
                return stats.unlockedSchematics.get(count + 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getLastSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        EntityClientPlayerMP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((EntityPlayerSP)player);
        for (int i = 0; i < stats.unlockedSchematics.size(); ++i) {
            idList.put(i, stats.unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count - 1 >= 0) {
                return stats.unlockedSchematics.get(count - 1);
            }
            return null;
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerDeath(PlayerDropsEvent event) {
        if (event.entityLiving instanceof EntityPlayerMP) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)event.entityLiving);
            if (!event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                event.entityLiving.captureDrops = true;
                for (int i = stats.extendedInventory.func_70302_i_() - 1; i >= 0; --i) {
                    ItemStack stack = stats.extendedInventory.func_70301_a(i);
                    if (stack == null) continue;
                    ((EntityPlayerMP)event.entityLiving).func_146097_a(stack, true, false);
                    stats.extendedInventory.func_70299_a(i, null);
                }
                event.entityLiving.captureDrops = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onLeaveBedButtonClicked(SleepCancelledEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        ChunkCoordinates c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event0 = new EventWakePlayer((EntityPlayer)player, c.field_71574_a, c.field_71572_b, c.field_71573_c, false, true, true, true);
            MinecraftForge.EVENT_BUS.post((Event)event0);
            player.func_70999_a(false, true, true);
        }
    }

    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.entity instanceof EntityEvolvedZombie) {
            event.customSummonedAid = new EntityEvolvedZombie(event.world);
            if ((double)((EntityLivingBase)event.entity).func_70681_au().nextFloat() < ((EntityEvolvedZombie)event.entity).func_110148_a(((EntityEvolvedZombie)event.entity).getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void overrideSkyColor(EntityViewRenderEvent.FogColors event) {
        if (event.entity.func_70644_a(Potion.field_76439_r)) {
            WorldClient worldclient = Minecraft.func_71410_x().field_71441_e;
            if (worldclient.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)worldclient.field_73011_w).getCelestialBody().atmosphere.size() == 0 && event.block.func_149688_o() == Material.field_151579_a && !((IGalacticraftWorldProvider)worldclient.field_73011_w).hasBreathableAtmosphere()) {
                Vec3 vec = worldclient.func_72948_g(1.0f);
                event.red = (float)vec.field_72450_a;
                event.green = (float)vec.field_72448_b;
                event.blue = (float)vec.field_72449_c;
                return;
            }
            if (worldclient.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld && event.entity.field_70163_u > 200.0) {
                Vec3 vec = WorldUtil.getFogColorHook(event.entity.field_70170_p);
                event.red = (float)vec.field_72450_a;
                event.green = (float)vec.field_72448_b;
                event.blue = (float)vec.field_72449_c;
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onSoundPlayed(PlaySoundEvent17 event) {
        if (event.result == null) {
            return;
        }
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (player != null && player.field_70170_p != null && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && event != null && event.result.func_147656_j() != ISound.AttenuationType.NONE) {
            PlayerGearData gearData = ClientProxyCore.playerItemData.get(player.func_146103_bH().getName());
            float x = event.result.func_147649_g();
            float y = event.result.func_147654_h();
            float z = event.result.func_147651_i();
            if (gearData == null || gearData.getFrequencyModule() == -1) {
                AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)((double)x - 0.0015), (double)((double)y - 0.0015), (double)((double)z - 0.0015), (double)((double)x + 0.0015), (double)((double)y + 0.0015), (double)((double)z + 0.0015));
                boolean playerInAtmosphere = OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player);
                boolean soundInAtmosphere = OxygenUtil.isAABBInBreathableAirBlock(player.field_70170_p, bb);
                if (!playerInAtmosphere || !soundInAtmosphere) {
                    float volume = event.result.func_147653_e();
                    for (int i = 0; i < this.soundPlayList.size(); ++i) {
                        SoundPlayEntry entry = this.soundPlayList.get(i);
                        if (!entry.name.equals(event.name) || entry.x != x || entry.y != y || entry.z != z || entry.volume != volume) continue;
                        this.soundPlayList.remove(i);
                        return;
                    }
                    float newVolume = volume / Math.max(0.01f, ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getSoundVolReductionAmount());
                    this.soundPlayList.add(new SoundPlayEntry(event.name, x, y, z, newVolume));
                    PositionedSoundRecord newSound = new PositionedSoundRecord(event.result.func_147650_b(), newVolume, event.result.func_147655_f(), x, y, z);
                    event.manager.func_148611_c((ISound)newSound);
                    event.result = null;
                    return;
                }
            }
        }
    }

    public static class OrientCameraEvent
    extends Event {
    }

    public static class SleepCancelledEvent
    extends Event {
    }

    private static class SoundPlayEntry {
        private final String name;
        private final float x;
        private final float y;
        private final float z;
        private final float volume;

        private SoundPlayEntry(String name, float x, float y, float z, float volume) {
            this.name = name;
            this.volume = volume;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

