/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.lang.reflect.Method;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyUtil {
    private static boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
    private static boolean isRFLoaded = EnergyConfigHandler.isRFAPILoaded();
    private static boolean isRF1Loaded = EnergyConfigHandler.isRFAPIv1Loaded();
    private static boolean isRF2Loaded = EnergyConfigHandler.isRFAPIv2Loaded();
    private static boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
    private static boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded();
    private static boolean isBC6Loaded = isBCLoaded && EnergyConfigHandler.getBuildcraftVersion() == 6;
    private static boolean isBCReallyLoaded = EnergyConfigHandler.isBuildcraftReallyLoaded();
    public static boolean voltageParameterIC2 = false;
    public static Method demandedEnergyIC2 = null;
    public static Method injectEnergyIC2 = null;
    public static Method offeredEnergyIC2 = null;
    public static Method drawEnergyIC2 = null;
    private static Class<?> clazzMekCable = null;
    public static Class<?> clazzEnderIOCable = null;
    public static Class<?> clazzMFRRednetEnergyCable = null;
    public static Class<?> clazzRailcraftEngine = null;
    private static Class<?> clazzPipeTile = null;
    private static Class<?> clazzPipeWood = null;
    public static boolean initialisedIC2Methods = EnergyUtil.initialiseIC2Methods();

    public static TileEntity[] getAdjacentPowerConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[6];
        BlockVec3 thisVec = new BlockVec3(tile);
        World world = tile.func_145831_w();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(world, direction);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.POWER)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isMekLoaded && (tileEntity instanceof IStrictEnergyAcceptor || tileEntity instanceof ICableOutputter)) {
                try {
                    if (clazzMekCable != null && clazzMekCable.isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tileEntity instanceof IStrictEnergyAcceptor && ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof ICableOutputter) || !((ICableOutputter)tileEntity).canOutputTo(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isBCReallyLoaded) {
                try {
                    if (clazzPipeTile.isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (isIC2Loaded && tileEntity instanceof IEnergyTile) {
                if (tileEntity instanceof IEnergyConductor) continue;
                boolean doneIC2 = false;
                if (tileEntity instanceof IEnergyAcceptor) {
                    doneIC2 = true;
                    if (((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, direction.getOpposite())) {
                        adjacentConnections[direction.ordinal()] = tileEntity;
                    }
                }
                if (tileEntity instanceof IEnergyEmitter) {
                    doneIC2 = true;
                    if (((IEnergyEmitter)tileEntity).emitsEnergyTo(tile, direction.getOpposite())) {
                        adjacentConnections[direction.ordinal()] = tileEntity;
                    }
                }
                if (doneIC2) continue;
            }
            if (isRFLoaded && tileEntity instanceof IEnergyConnection) {
                if ((!isRF2Loaded || !(tileEntity instanceof IEnergyProvider) && !(tileEntity instanceof IEnergyReceiver)) && (!isRF1Loaded || !(tileEntity instanceof IEnergyHandler)) && (clazzRailcraftEngine == null || !clazzRailcraftEngine.isInstance(tileEntity)) || clazzEnderIOCable != null && clazzEnderIOCable.isInstance(tileEntity) || clazzMFRRednetEnergyCable != null && clazzMFRRednetEnergyCable.isInstance(tileEntity) || !((IEnergyConnection)tileEntity).canConnectEnergy(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!isBCLoaded) continue;
            if (isBC6Loaded && MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)direction.getOpposite()) != null) {
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!(tileEntity instanceof IPowerReceptor) || ((IPowerReceptor)tileEntity).getPowerReceiver(direction.getOpposite()) == null) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static float otherModsEnergyTransfer(TileEntity tileAdj, ForgeDirection inputAdj, float toSend, boolean simulate) {
        if (isMekLoaded && !EnergyConfigHandler.disableMekanismOutput && tileAdj instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor tileMek = (IStrictEnergyAcceptor)tileAdj;
            if (tileMek.canReceiveEnergy(inputAdj)) {
                float transferredMek = simulate ? (tileMek.canReceiveEnergy(inputAdj) ? (float)(tileMek.getMaxEnergy() - tileMek.getEnergy()) : 0.0f) : (float)tileMek.transferEnergyToAcceptor(inputAdj, (double)(toSend * EnergyConfigHandler.TO_MEKANISM_RATIO));
                return transferredMek / EnergyConfigHandler.TO_MEKANISM_RATIO;
            }
        } else if (isIC2Loaded && !EnergyConfigHandler.disableIC2Output && tileAdj instanceof IEnergySink) {
            double demanded;
            block18: {
                demanded = 0.0;
                try {
                    demanded = (Double)demandedEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block18;
                    ex.printStackTrace();
                }
            }
            if (simulate) {
                return Math.min(toSend, (float)demanded / EnergyConfigHandler.TO_IC2_RATIO);
            }
            double energySendingIC2 = Math.min((double)(toSend * EnergyConfigHandler.TO_IC2_RATIO), demanded);
            if (energySendingIC2 >= 1.0) {
                double result;
                block19: {
                    result = 0.0;
                    try {
                        result = voltageParameterIC2 ? energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2, 120.0) : energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block19;
                        ex.printStackTrace();
                    }
                }
                if (result < 0.0) {
                    return 0.0f;
                }
                return (float)result / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            PowerHandler.PowerReceiver receiver;
            if (isRF1Loaded && !EnergyConfigHandler.disableRFOutput && tileAdj instanceof IEnergyHandler) {
                float sent = (float)((IEnergyHandler)tileAdj).receiveEnergy(inputAdj, MathHelper.func_76141_d((float)(toSend * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
            if (isRF2Loaded && !EnergyConfigHandler.disableRFOutput && tileAdj instanceof IEnergyReceiver) {
                float sent = (float)((IEnergyReceiver)tileAdj).receiveEnergy(inputAdj, MathHelper.func_76141_d((float)(toSend * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
            if (isBC6Loaded && !EnergyConfigHandler.disableBuildCraftOutput && MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj) != null) {
                double toSendBC = Math.min((double)(toSend * EnergyConfigHandler.TO_BC_RATIO), MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj).getEnergyRequested());
                if (simulate) {
                    return (float)toSendBC / EnergyConfigHandler.TO_BC_RATIO;
                }
                float sent = (float)MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj).addEnergy(toSendBC) / EnergyConfigHandler.TO_BC_RATIO;
                return sent;
            }
            if (isBCLoaded && !EnergyConfigHandler.disableBuildCraftOutput && tileAdj instanceof IPowerReceptor && (receiver = ((IPowerReceptor)tileAdj).getPowerReceiver(inputAdj)) != null) {
                double toSendBC = Math.min((double)(toSend * EnergyConfigHandler.TO_BC_RATIO), Math.min(receiver.powerRequest(), receiver.getMaxEnergyReceived()));
                if (simulate) {
                    return (float)toSendBC / EnergyConfigHandler.TO_BC_RATIO;
                }
                float rec = (float)receiver.receiveEnergy(PowerHandler.Type.PIPE, toSendBC, inputAdj);
                return rec / EnergyConfigHandler.TO_BC_RATIO;
            }
        }
        return 0.0f;
    }

    public static float otherModsEnergyExtract(TileEntity tileAdj, ForgeDirection inputAdj, float toPull, boolean simulate) {
        if (isIC2Loaded && !EnergyConfigHandler.disableIC2Input && tileAdj instanceof IEnergySource) {
            double offered;
            block11: {
                offered = 0.0;
                try {
                    offered = (Double)offeredEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block11;
                    ex.printStackTrace();
                }
            }
            if (simulate) {
                return Math.min(toPull, (float)offered / EnergyConfigHandler.TO_IC2_RATIO);
            }
            double energySendingIC2 = Math.min((double)(toPull * EnergyConfigHandler.TO_IC2_RATIO), offered);
            if (energySendingIC2 >= 1.0) {
                double resultIC2;
                block12: {
                    resultIC2 = 0.0;
                    try {
                        resultIC2 = energySendingIC2 - (Double)drawEnergyIC2.invoke((Object)tileAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block12;
                        ex.printStackTrace();
                    }
                }
                if (resultIC2 < 0.0) {
                    resultIC2 = 0.0;
                }
                return (float)resultIC2 / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            if (isRF2Loaded && !EnergyConfigHandler.disableRFInput && tileAdj instanceof IEnergyProvider) {
                float sent = (float)((IEnergyProvider)tileAdj).extractEnergy(inputAdj, MathHelper.func_76141_d((float)(toPull * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
            if (isRF1Loaded && !EnergyConfigHandler.disableRFInput && tileAdj instanceof IEnergyHandler) {
                float sent = (float)((IEnergyHandler)tileAdj).extractEnergy(inputAdj, MathHelper.func_76141_d((float)(toPull * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
        }
        return 0.0f;
    }

    public static boolean otherModCanReceive(TileEntity tileAdj, ForgeDirection inputAdj) {
        if (tileAdj instanceof TileBaseConductor || tileAdj instanceof EnergyStorageTile) {
            return false;
        }
        if (isMekLoaded && tileAdj instanceof IStrictEnergyAcceptor) {
            return ((IStrictEnergyAcceptor)tileAdj).canReceiveEnergy(inputAdj);
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyAcceptor) {
            return ((IEnergyAcceptor)tileAdj).acceptsEnergyFrom(null, inputAdj);
        }
        if (isRF1Loaded && tileAdj instanceof IEnergyHandler || isRF2Loaded && tileAdj instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tileAdj).canConnectEnergy(inputAdj);
        }
        if (isBC6Loaded && MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj) != null) {
            return true;
        }
        if (isBCLoaded && tileAdj instanceof IPowerReceptor) {
            return ((IPowerReceptor)tileAdj).getPowerReceiver(inputAdj) != null;
        }
        return false;
    }

    public static boolean otherModCanProduce(TileEntity tileAdj, ForgeDirection side) {
        if (tileAdj instanceof TileBaseConductor || tileAdj instanceof EnergyStorageTile) {
            return false;
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)tileAdj).emitsEnergyTo(null, side);
        }
        if (isRF1Loaded && tileAdj instanceof IEnergyHandler || isRF2Loaded && tileAdj instanceof IEnergyProvider) {
            return ((IEnergyConnection)tileAdj).canConnectEnergy(side);
        }
        return false;
    }

    public static boolean initialiseIC2Methods() {
        try {
            clazzMekCable = Class.forName("codechicken.multipart.TileMultipart");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzEnderIOCable = Class.forName("crazypants.enderio.conduit.TileConduitBundle");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzMFRRednetEnergyCable = Class.forName("powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzRailcraftEngine = Class.forName("mods.railcraft.common.blocks.machine.beta.TileEngine");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzPipeTile = Class.forName("buildcraft.transport.TileGenericPipe");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzPipeWood = Class.forName("buildcraft.transport.pipes.PipePowerWood");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isIC2Loaded) {
            GCLog.debug("Initialising IC2 methods OK");
            try {
                Class<?> clazz = Class.forName("ic2.api.energy.tile.IEnergySink");
                GCLog.debug("Found IC2 IEnergySink class OK");
                try {
                    demandedEnergyIC2 = clazz.getMethod("demandedEnergyUnits", new Class[0]);
                }
                catch (Exception e) {
                    try {
                        demandedEnergyIC2 = clazz.getMethod("getDemandedEnergy", new Class[0]);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                GCLog.debug("Set IC2 demandedEnergy method OK");
                try {
                    injectEnergyIC2 = clazz.getMethod("injectEnergyUnits", ForgeDirection.class, Double.TYPE);
                    GCLog.debug("IC2 inject 1.7.2 succeeded");
                }
                catch (Exception e) {
                    try {
                        injectEnergyIC2 = clazz.getMethod("injectEnergy", ForgeDirection.class, Double.TYPE, Double.TYPE);
                        voltageParameterIC2 = true;
                        GCLog.debug("IC2 inject 1.7.10 succeeded");
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                Class<?> clazzSource = Class.forName("ic2.api.energy.tile.IEnergySource");
                offeredEnergyIC2 = clazzSource.getMethod("getOfferedEnergy", new Class[0]);
                drawEnergyIC2 = clazzSource.getMethod("drawEnergy", Double.TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

