/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.vector;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockVec3Dim
implements Cloneable {
    public int x;
    public int y;
    public int z;
    public int dim;
    private static Chunk chunkCached;
    public static int chunkCacheDim;
    private static int chunkCacheX;
    private static int chunkCacheZ;
    public static final BlockVec3Dim INVALID_VECTOR;

    public BlockVec3Dim() {
        this(0, 0, 0, 0);
    }

    public BlockVec3Dim(int x, int y, int z, int d) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = d;
    }

    public BlockVec3Dim(Entity par1) {
        this.x = (int)Math.floor(par1.field_70165_t);
        this.y = (int)Math.floor(par1.field_70163_u);
        this.z = (int)Math.floor(par1.field_70161_v);
        this.dim = par1.field_71093_bK;
    }

    public BlockVec3Dim(TileEntity par1) {
        this.x = par1.field_145851_c;
        this.y = par1.field_145848_d;
        this.z = par1.field_145849_e;
        this.dim = par1.func_145831_w().field_73011_w.field_76574_g;
    }

    public final BlockVec3Dim clone() {
        return new BlockVec3Dim(this.x, this.y, this.z, this.dim);
    }

    public Block getBlockID() {
        if (this.y < 0 || this.y >= 256 || this.x < -30000000 || this.z < -30000000 || this.x >= 30000000 || this.z >= 30000000) {
            return null;
        }
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return null;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.field_76574_g && BlockVec3Dim.chunkCached.field_76636_d) {
                return chunkCached.func_150810_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            Chunk chunk = null;
            chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
            chunkCacheDim = world.field_73011_w.field_76574_g;
            chunkCacheX = chunkx;
            chunkCacheZ = chunkz;
            return chunk.func_150810_a(this.x & 0xF, this.y, this.z & 0xF);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_85071_a((int)this.x, (int)this.y, (int)this.z));
            throw new ReportedException(crashreport);
        }
    }

    public Block getBlockID_noChunkLoad() {
        if (this.y < 0 || this.y >= 256 || this.x < -30000000 || this.z < -30000000 || this.x >= 30000000 || this.z >= 30000000) {
            return null;
        }
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return null;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            if (world.func_72863_F().func_73149_a(chunkx, chunkz)) {
                if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.field_76574_g && BlockVec3Dim.chunkCached.field_76636_d) {
                    return chunkCached.func_150810_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                Chunk chunk = null;
                chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
                chunkCacheDim = world.field_73011_w.field_76574_g;
                chunkCacheX = chunkx;
                chunkCacheZ = chunkz;
                return chunk.func_150810_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            return Blocks.field_150357_h;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_85071_a((int)this.x, (int)this.y, (int)this.z));
            throw new ReportedException(crashreport);
        }
    }

    public Block getBlock() {
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return null;
        }
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public BlockVec3Dim modifyPositionFromSide(ForgeDirection side, int amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
            }
        }
        return this;
    }

    public BlockVec3Dim newVecSide(int side) {
        BlockVec3Dim vec = new BlockVec3Dim(this.x, this.y, this.z, this.dim);
        switch (side) {
            case 0: {
                --vec.y;
                return vec;
            }
            case 1: {
                ++vec.y;
                return vec;
            }
            case 2: {
                --vec.z;
                return vec;
            }
            case 3: {
                ++vec.z;
                return vec;
            }
            case 4: {
                --vec.x;
                return vec;
            }
            case 5: {
                ++vec.x;
                return vec;
            }
        }
        return vec;
    }

    public BlockVec3Dim modifyPositionFromSide(ForgeDirection side) {
        return this.modifyPositionFromSide(side, 1);
    }

    public int hashCode() {
        return (((this.z * 431 + this.x) * 379 + this.y) * 373 + this.dim) * 7;
    }

    public boolean equals(Object o) {
        if (o instanceof BlockVec3Dim) {
            BlockVec3Dim vector = (BlockVec3Dim)o;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z && this.dim == vector.dim;
        }
        return false;
    }

    public String toString() {
        return "BlockVec3 " + this.dim + ":[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public TileEntity getTileEntity() {
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return null;
        }
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public int getBlockMetadata() {
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return 0;
        }
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public static BlockVec3Dim readFromNBT(NBTTagCompound nbtCompound) {
        BlockVec3Dim tempVector = new BlockVec3Dim();
        tempVector.x = nbtCompound.func_74762_e("x");
        tempVector.y = nbtCompound.func_74762_e("y");
        tempVector.z = nbtCompound.func_74762_e("z");
        tempVector.dim = nbtCompound.func_74762_e("dim");
        return tempVector;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("x", this.x);
        par1NBTTagCompound.func_74768_a("y", this.y);
        par1NBTTagCompound.func_74768_a("z", this.z);
        par1NBTTagCompound.func_74768_a("dim", this.dim);
        return par1NBTTagCompound;
    }

    public BlockVec3Dim(NBTTagCompound par1NBTTagCompound) {
        this.x = par1NBTTagCompound.func_74762_e("x");
        this.y = par1NBTTagCompound.func_74762_e("y");
        this.z = par1NBTTagCompound.func_74762_e("z");
        this.dim = par1NBTTagCompound.func_74762_e("dim");
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public int getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void setBlock(Block block) {
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return;
        }
        world.func_147465_d(this.x, this.y, this.z, block, 0, 3);
    }

    public boolean blockExists() {
        World world = this.getWorldForId(this.dim);
        if (world == null) {
            return false;
        }
        return world.func_72899_e(this.x, this.y, this.z);
    }

    public int distanceSquared(BlockVec3 vector) {
        int var2 = vector.x - this.x;
        int var4 = vector.y - this.y;
        int var6 = vector.z - this.z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    private World getWorldForId(int dimensionID) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (theServer == null) {
                return null;
            }
            return theServer.func_71218_a(dimensionID);
        }
        return this.getWorldForIdClient(dimensionID);
    }

    @SideOnly(value=Side.CLIENT)
    private World getWorldForIdClient(int dimensionID) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world != null && world.field_73011_w.field_76574_g == dimensionID) {
            return world;
        }
        return null;
    }

    static {
        chunkCacheDim = Integer.MAX_VALUE;
        chunkCacheX = 1876000;
        chunkCacheZ = 1876000;
        INVALID_VECTOR = new BlockVec3Dim(-1, -1, -1, -2);
    }
}

