/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import java.util.ArrayList;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.player.IPlayer;
import minetweaker.util.ArrayUtil;

public class IngredientOr
implements IIngredient {
    private final IIngredient[] elements;
    private final String mark;
    private final IItemCondition[] conditions;
    private final IItemTransformer[] transformers;

    public IngredientOr(IIngredient[] elements) {
        this.elements = elements;
        this.mark = null;
        this.conditions = ArrayUtil.EMPTY_CONDITIONS;
        this.transformers = ArrayUtil.EMPTY_TRANSFORMERS;
    }

    public IngredientOr(IIngredient a, IIngredient b) {
        this(new IIngredient[]{a, b});
    }

    private IngredientOr(IIngredient[] elements, String mark, IItemCondition[] conditions, IItemTransformer[] transformers) {
        this.elements = elements;
        this.mark = mark;
        this.conditions = conditions;
        this.transformers = transformers;
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public int getAmount() {
        return this.elements[0].getAmount();
    }

    @Override
    public List<IItemStack> getItems() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (IIngredient element : this.elements) {
            result.addAll(element.getItems());
        }
        return result;
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        ArrayList<ILiquidStack> result = new ArrayList<ILiquidStack>();
        for (IIngredient element : this.elements) {
            result.addAll(element.getLiquids());
        }
        return result;
    }

    @Override
    public IIngredient amount(int amount) {
        IIngredient[] result = new IIngredient[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            result[i] = this.elements[i].amount(amount);
        }
        return new IngredientOr(result);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOr(this.elements, this.mark, this.conditions, ArrayUtil.append(this.transformers, transformer));
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOr(this.elements, this.mark, ArrayUtil.append(this.conditions, condition), this.transformers);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOr(this.elements, mark, this.conditions, this.transformers);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(ArrayUtil.append(this.elements, ingredient));
    }

    @Override
    public boolean matches(IItemStack item) {
        for (IIngredient ingredient : this.elements) {
            if (!ingredient.matches(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        for (IIngredient ingredient : this.elements) {
            if (!ingredient.matches(liquid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        for (IItemTransformer transformer : this.transformers) {
            item = transformer.transform(item, byPlayer);
        }
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return this.transformers.length > 0;
    }

    @Override
    public Object getInternal() {
        return null;
    }
}

