/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.JsonArray;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonObject;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonNodeFactories {
    public static JsonStringNode string(String value) {
        return new JsonStringNode(value);
    }

    public static JsonRootNode array(Iterable<? extends JsonNode> elements) {
        return new JsonArray(elements);
    }

    public static JsonRootNode array(JsonNode ... elements) {
        return JsonNodeFactories.array(Arrays.asList(elements));
    }

    public static JsonRootNode object(final Map<JsonStringNode, ? extends JsonNode> fields) {
        return new JsonObject((Iterable<JsonField>)new ArrayList<JsonField>(){
            {
                for (Map.Entry entry : fields.entrySet()) {
                    this.add(JsonNodeFactories.field((JsonStringNode)entry.getKey(), (JsonNode)entry.getValue()));
                }
            }
        });
    }

    public static JsonRootNode object(JsonField ... fields) {
        return JsonNodeFactories.object(Arrays.asList(fields));
    }

    public static JsonRootNode object(Iterable<JsonField> fields) {
        return new JsonObject(fields);
    }

    public static JsonField field(String name, JsonNode value) {
        return new JsonField(JsonNodeFactories.string(name), value);
    }

    public static JsonField field(JsonStringNode name, JsonNode value) {
        return new JsonField(name, value);
    }
}

