/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.Cancelable;
import net.minecraftforge.event.world.BlockEvent;

public class NoteBlockEvent
extends BlockEvent {
    private int noteId;

    NoteBlockEvent(afn world, int x, int y2, int z2, int meta, int note) {
        super(x, y2, z2, world, ahz.B, meta);
        this.noteId = note;
    }

    public Note getNote() {
        return Note.fromId(this.noteId);
    }

    public Octave getOctave() {
        return Octave.fromId(this.noteId);
    }

    public int getVanillaNoteId() {
        return this.noteId;
    }

    public void setNote(Note note, Octave octave) {
        Preconditions.checkArgument((octave != Octave.HIGH || note == Note.F_SHARP ? 1 : 0) != 0, (Object)"Octave.HIGH is only valid for Note.F_SHARP!");
        this.noteId = note.ordinal() + octave.ordinal() * 12;
    }

    public static enum Octave {
        LOW,
        MID,
        HIGH;


        static Octave fromId(int id) {
            return id < 12 ? LOW : (id == 24 ? HIGH : MID);
        }
    }

    public static enum Note {
        F_SHARP,
        G,
        G_SHARP,
        A,
        A_SHARP,
        B,
        C,
        C_SHARP,
        D,
        D_SHARP,
        E,
        F;

        private static final Note[] values;

        static Note fromId(int id) {
            return values[id % 12];
        }

        static {
            values = Note.values();
        }
    }

    public static enum Instrument {
        PIANO,
        BASSDRUM,
        SNARE,
        CLICKS,
        BASSGUITAR;

        private static final Instrument[] values;

        static Instrument fromId(int id) {
            return id < 0 || id > 4 ? PIANO : values[id];
        }

        static {
            values = Instrument.values();
        }
    }

    @Cancelable
    public static class Change
    extends NoteBlockEvent {
        public final Note oldNote;
        public final Octave oldOctave;

        public Change(afn world, int x, int y2, int z2, int meta, int oldNote, int newNote) {
            super(world, x, y2, z2, meta, newNote);
            this.oldNote = Note.fromId(oldNote);
            this.oldOctave = Octave.fromId(oldNote);
        }
    }

    @Cancelable
    public static class Play
    extends NoteBlockEvent {
        public Instrument instrument;

        public Play(afn world, int x, int y2, int z2, int meta, int note, int instrument) {
            super(world, x, y2, z2, meta, note);
            this.instrument = Instrument.fromId(instrument);
        }
    }
}

