/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class FMLHandshakeMessage {
    public static FMLProxyPacket makeCustomChannelRegistration(Set<String> channels) {
        String salutation = Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML|HS", "FML"), channels));
        FMLProxyPacket proxy = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])salutation.getBytes(Charsets.UTF_8)), "REGISTER");
        return proxy;
    }

    public void fromBytes(ByteBuf buffer) {
    }

    public void toBytes(ByteBuf buffer) {
    }

    public String toString(Class<? extends Enum<?>> side) {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(36));
    }

    public static class HandshakeAck
    extends FMLHandshakeMessage {
        int phase;

        public HandshakeAck() {
        }

        HandshakeAck(int phase) {
            this.phase = phase;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.phase = buffer.readByte();
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(this.phase);
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":{" + this.phase + "}";
        }
    }

    public static class ModIdData
    extends FMLHandshakeMessage {
        private Map<String, Integer> modIds;

        public ModIdData() {
        }

        public ModIdData(Map<String, Integer> modIds) {
            this.modIds = modIds;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            int length = ByteBufUtils.readVarInt(buffer, 3);
            this.modIds = Maps.newHashMap();
            for (int i = 0; i < length; ++i) {
                this.modIds.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readVarInt(buffer, 3));
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            ByteBufUtils.writeVarInt(buffer, this.modIds.size(), 3);
            for (Map.Entry<String, Integer> entry : this.modIds.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, entry.getKey());
                ByteBufUtils.writeVarInt(buffer, entry.getValue(), 3);
            }
        }

        public Map<String, Integer> dataList() {
            return this.modIds;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.modIds.size() + " mappings";
        }
    }

    public static class ModList
    extends FMLHandshakeMessage {
        private Map<String, String> modTags = Maps.newHashMap();

        public ModList() {
        }

        public ModList(List<ModContainer> modList) {
            for (ModContainer mod : modList) {
                this.modTags.put(mod.getModId(), mod.getVersion());
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            super.toBytes(buffer);
            ByteBufUtils.writeVarInt(buffer, this.modTags.size(), 2);
            for (Map.Entry<String, String> modTag : this.modTags.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, modTag.getKey());
                ByteBufUtils.writeUTF8String(buffer, modTag.getValue());
            }
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            super.fromBytes(buffer);
            int modCount = ByteBufUtils.readVarInt(buffer, 2);
            for (int i = 0; i < modCount; ++i) {
                this.modTags.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readUTF8String(buffer));
            }
        }

        public String modListAsString() {
            return Joiner.on((char)',').withKeyValueSeparator("@").join(this.modTags);
        }

        public int modListSize() {
            return this.modTags.size();
        }

        public Map<String, String> modList() {
            return this.modTags;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.modTags.size() + " mods";
        }
    }

    public static class ClientHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(1);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }
    }

    public static class ServerHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(1);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }
    }
}

