
-- base_id.lua
-- Invade / Defend gametype 

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_teamplay")

-----------------------------------------------------------------------------
-- globals
-----------------------------------------------------------------------------
if POINTS_PER_CAPTURE == nil then POINTS_PER_CAPTURE = 10; end
if POINTS_PER_PERIOD == nil then POINTS_PER_PERIOD = 2; end
if PERIOD_TIME == nil then PERIOD_TIME = 30; end
if NUM_PHASES == nil then NUM_PHASES = 4; end
if INITIAL_ROUND_DELAY == nil then INITIAL_ROUND_DELAY = 45; end
if ROUND_DELAY == nil then ROUND_DELAY = 15; end
if onroundreset == nil then onroundreset = function() end end
if FLAG_RETURN_TIME == nil then FLAG_RETURN_TIME = 60; end
if ATTACKERS_OBJECTIVE_ENTITY == nil then ATTACKERS_OBJECTIVE_ENTITY = nil end
if TEAM_SWITCH_DELAY == nil then TEAM_SWITCH_DELAY = 2 end

basecap = trigger_ff_script:new({
	health = 100,
	armor = 300,
	grenades = 200,
	nails = 200,
	shells = 200,
	rockets = 200,
	cells = 200,
	detpacks = 1,
	mancannons = 1,
	gren1 = 0,
	gren2 = 0,
	item = "",
	team = 0,
	botgoaltype = Bot.kFlagCap,
})

function basecap:allowed ( allowed_entity )
	if IsPlayer( allowed_entity ) then
		-- get the player and his team
		local player = CastToPlayer( allowed_entity )
		local team = player:GetTeam()
	
		-- check if the player is on our team
		if team:GetTeamId() ~= self.team then
			return false
		end
	
		-- check if the player has the flag
		for i,v in ipairs(self.item) do
			local flag = GetInfoScriptByName(v)
			
			-- Make sure flag isn't nil
			if flag then
				if player:HasItem(flag:GetName()) then
					return true
				end
			end
		end
	end
	
	return false
end

function basecap:ontrigger ( trigger_entity )
	if IsPlayer( trigger_entity ) then
		local player = CastToPlayer( trigger_entity )

		-- player should capture now
		for i,v in ipairs( self.item ) do
			
			-- find the flag and cast it to an info_ff_script
			local flag = GetInfoScriptByName(v)

			-- Make sure flag isn't nil
			if flag then
			
				-- check if the player is carrying the flag
				if player:HasItem(flag:GetName()) then
			
					-- reward player for capture
					player:AddFortPoints(FORTPOINTS_PER_CAPTURE, "#FF_FORTPOINTS_CAPTUREFLAG")
				
					-- reward player's team for capture
					local team = player:GetTeam()
					team:AddScore(POINTS_PER_CAPTURE)
			
					
					-- Remove any hud icons
					-- local flag2 = CastToInfoScript(flag)
					RemoveHudItem( player, flag:GetName() )
					RemoveHudItemFromAll( flag:GetName() .. "_c" )

					-- return the flag
					flag:Return()
				
					-- give player some health and armor
					if self.health ~= nil and self.health ~= 0 then player:AddHealth(self.health) end
					if self.armor ~= nil and self.armor ~= 0 then player:AddArmor(self.armor) end
	
					-- give the player some ammo
					if self.nails ~= nil and self.nails ~= 0 then player:AddAmmo(Ammo.kNails, self.nails) end
					if self.shells ~= nil and self.shells ~= 0 then player:AddAmmo(Ammo.kShells, self.shells) end
					if self.rockets ~= nil and self.rockets ~= 0 then player:AddAmmo(Ammo.kRockets, self.rockets) end
					if self.cells ~= nil and self.cells ~= 0 then player:AddAmmo(Ammo.kCells, self.cells) end
					if self.detpacks ~= nil and self.detpacks ~= 0 then player:AddAmmo(Ammo.kDetpack, self.detpacks) end
					if self.mancannons ~= nil and self.mancannons ~= 0 then player:AddAmmo(Ammo.kManCannon, self.mancannons) end
					if self.gren1 ~= nil and self.gren1 ~= 0 then player:AddAmmo(Ammo.kGren1, self.gren1) end
					if self.gren2 ~= nil and self.gren2 ~= 0 then player:AddAmmo(Ammo.kGren2, self.gren2) end
	
					self:oncapture( player, v )
				end
			end
		end
	end
end

function basecap:oncapture(player, item)
	-- let the teams know that a capture occured
	SmartSound(player, "yourteam.flagcap", "yourteam.flagcap", "otherteam.flagcap")
--SmartSound(player, "vox.yourcap", "vox.yourcap", "vox.enemycap")
	SmartSpeak(player, "CTF_YOUCAP", "CTF_TEAMCAP", "CTF_THEYCAP")
	SmartMessage(player, "#FF_YOUCAP", "#FF_TEAMCAP", "#FF_OTHERTEAMCAP")
end

function baseflag:ownercloak( owner_entity )
	-- drop the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, 0.0)
	
	-- remove flag icon from hud
	local player = CastToPlayer( owner_entity )
	RemoveHudItem( player, flag:GetName() )
	RemoveHudItemFromAll( flag:GetName() .. "_c" )
	AddHudIconToAll( self.hudstatusicondropped, ( flag:GetName() .. "_d" ), self.hudstatusiconx, self.hudstatusicony, self.hudstatusiconw, self.hudstatusiconh, self.hudstatusiconalign )
	self.status = 2
	
	-- objective icon
	ATTACKERS_OBJECTIVE_ENTITY = GetEntityByName( "cp"..phase.."_flag" )
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end

function baseflag:dropitemcmd( owner_entity )

	if allowdrop == false then return end

	-- throw the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, FLAG_THROW_SPEED)
	
	-- remove flag icon from hud
	local player = CastToPlayer( owner_entity )
	RemoveHudItem( player, flag:GetName() )
	RemoveHudItemFromAll( flag:GetName() .. "_c" )
	AddHudIconToAll( self.hudstatusicondropped, ( flag:GetName() .. "_d" ), self.hudstatusiconx, self.hudstatusicony, self.hudstatusiconw, self.hudstatusiconh, self.hudstatusiconalign )
	self.status = 2
	
	-- objective icon
	ATTACKERS_OBJECTIVE_ENTITY = GetEntityByName( "cp"..phase.."_flag" )
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end	

function baseflag:onownerforcerespawn( owner_entity )
	local flag = CastToInfoScript( entity )
	local player = CastToPlayer( owner_entity )
	player:SetDisguisable( true )
	player:SetCloakable( true )
	RemoveHudItem( player, flag:GetName() )	
	flag:Drop(0, FLAG_THROW_SPEED)
	RemoveHudItemFromAll( flag:GetName() .. "_d" )
	RemoveHudItemFromAll( flag:GetName() .. "_c" )
	AddHudIconToAll( self.hudstatusicondropped, ( flag:GetName() .. "_d" ), self.hudstatusiconx, self.hudstatusicony, self.hudstatusiconw, self.hudstatusiconh, self.hudstatusiconalign )
	self.status = 2
	
	-- objective icon
	ATTACKERS_OBJECTIVE_ENTITY = GetEntityByName( "cp"..phase.."_flag" )
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end

function baseflag:onreturn( )
	-- let the teams know that the flag was returned
	local team = GetTeam( self.team )
	SmartTeamMessage(team, "#FF_TEAMRETURN", "#FF_OTHERTEAMRETURN")
	SmartTeamSound(team, "yourteam.flagreturn", "otherteam.flagreturn")
	SmartTeamSpeak(team, "CTF_FLAGBACK", "CTF_EFLAGBACK")
	local flag = CastToInfoScript( entity )

	RemoveHudItemFromAll( flag:GetName() .. "_d" )
	RemoveHudItemFromAll( flag:GetName() .. "_c" )
	AddHudIconToAll( self.hudstatusiconhome, ( flag:GetName() .. "_h" ), self.hudstatusiconx, self.hudstatusicony, self.hudstatusiconw, self.hudstatusiconh, self.hudstatusiconalign )
	self.status = 0
	
	-- objective icon
	ATTACKERS_OBJECTIVE_ENTITY = flag
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end

phase = 1
attackers = Team.kBlue
defenders = Team.kRed

function startup()
	-- set up team limits
	local team = GetTeam( Team.kBlue )
	team:SetPlayerLimit( 0 )

	team = GetTeam( Team.kRed )
	team:SetPlayerLimit( 0 )

	team = GetTeam( Team.kYellow )
	team:SetPlayerLimit( -1 )

	team = GetTeam( Team.kGreen )
	team:SetPlayerLimit( -1 )

	-- CTF maps generally don't have civilians,
	-- so override in map LUA file if you want 'em
	local team = GetTeam(Team.kBlue)
	team:SetClassLimit(Player.kCivilian, -1)

	team = GetTeam(Team.kRed)
	team:SetClassLimit(Player.kCivilian, -1)

	-- start the timer for the points
	AddScheduleRepeating("addpoints", PERIOD_TIME, addpoints)

	setup_door_timer("start_gate", INITIAL_ROUND_DELAY)

	cp1_flag.enabled = true
	for i,v in ipairs({"cp1_flag", "cp2_flag", "cp3_flag", "cp4_flag", "cp5_flag", "cp6_flag", "cp7_flag", "cp8_flag"}) do
		local flag = GetInfoScriptByName(v)
		if flag then
			flag:SetModel(_G[v].model)
			flag:SetSkin(teamskins[attackers])
			if i == 1 then
				flag:Restore()
			else
				flag:Remove()
			end
		end
	end	 
	
	flags_set_team( attackers )
	
	ATTACKERS_OBJECTIVE_ENTITY = GetEntityByName( "cp"..phase.."_flag" )
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end

-- Give everyone a full resupply, but strip secondary grenades
function player_spawn( player_entity )
	local player = CastToPlayer( player_entity )

	player:AddHealth( 100 )
	player:AddArmor( 300 )

	player:AddAmmo( Ammo.kNails, 400 )
	player:AddAmmo( Ammo.kShells, 400 )
	player:AddAmmo( Ammo.kRockets, 400 )
	player:AddAmmo( Ammo.kCells, 400 )
	player:AddAmmo( Ammo.kDetpack, 1 )
	player:AddAmmo( Ammo.kManCannon, 1 )

	player:RemoveAmmo( Ammo.kGren2, 4 )
	
	if player:GetTeamId() == attackers then
		UpdateObjectiveIcon( player, ATTACKERS_OBJECTIVE_ENTITY )
	elseif player:GetTeamId() == defenders then
		UpdateObjectiveIcon( player, nil )
	end
end

function addpoints()
	local team = GetTeam(defenders)
	team:AddScore(POINTS_PER_PERIOD)
end

function precache()
	-- precache sounds
	PrecacheSound("yourteam.flagstolen")
	PrecacheSound("otherteam.flagstolen")
	PrecacheSound("yourteam.flagcap")
	PrecacheSound("otherteam.flagcap")
	PrecacheSound("yourteam.drop")
	PrecacheSound("otherteam.drop")
	PrecacheSound("yourteam.flagreturn")
	PrecacheSound("otherteam.flagreturn")
--	PrecacheSound("vox.yourcap")
--	PrecacheSound("vox.enemycap")
--	PrecacheSound("vox.yourstole")
--	PrecacheSound("vox.enemystole")
--	PrecacheSound("vox.yourflagret")
--	PrecacheSound("vox.enemyflagret")
end

-- kinda ghetto, sure
function flags_set_team( teamid )
	-- set all flags teams
	cp1_flag.team = teamid
	cp2_flag.team = teamid
	cp3_flag.team = teamid
	cp4_flag.team = teamid
	cp5_flag.team = teamid
	cp6_flag.team = teamid
	cp7_flag.team = teamid
	cp8_flag.team = teamid
end	
	

-----------------------------------------
-- base flag
-----------------------------------------
base_id_flag = baseflag:new({
	phase = 1,
	enabled = nil,
	touchflags = { AllowFlags.kOnlyPlayers, AllowFlags.kBlue, AllowFlags.kRed },
	hudicon = BLUE_FLAG_HUD_ICON,
})
function base_id_flag:touch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		-- pickup if they can
		if self.notouch[player:GetId()] then return; end

		if player:GetTeamId() == attackers and phase == self.phase and self.enabled then
			SmartSound(player, "yourteam.flagstolen", "yourteam.flagstolen", "otherteam.flagstolen")
			SmartSpeak(player, "CTF_YOUGOTFLAG", "CTF_GOTFLAG", "CTF_LOSTFLAG")
--SmartSound(player, "vox.yourstole", "vox.yourstole", "vox.enemystole")
			SmartMessage(player, "#FF_YOUPICKUP", "#FF_TEAMPICKUP", "#FF_OTHERTEAMPICKUP")
			
			local flag = CastToInfoScript(entity)
			flag:Pickup(player)
			player:SetDisguisable( false )
			-- if the player is a spy, then force him to lose his cloak
			player:SetCloakable( false )

			self.hudicon = team_hudicons[attackers] 
	
			AddHudIcon( player, self.hudicon, flag:GetName(), self.hudx, self.hudy, self.hudstatusiconw, self.hudstatusiconh, self.hudalign )
			
			-- change objective icons
			ATTACKERS_OBJECTIVE_ENTITY = player
			UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
			UpdateObjectiveIcon( player, GetEntityByName( "cp"..self.phase.."_cap" ) )
		end
	end
end

function base_id_flag:onownerdie( owner_entity )
	-- drop the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, 0.0)
	
	-- remove flag icon from hud
	local player = CastToPlayer( owner_entity )
	RemoveHudItem( player, flag:GetName() )

	player:SetDisguisable( true )
	player:SetCloakable( true )
	
	-- change objective icon
	ATTACKERS_OBJECTIVE_ENTITY = flag
	UpdateObjectiveIcon( player, nil )
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end

-----------------------------------------
-- base capture point
-----------------------------------------
base_id_cap = basecap:new({
	phase = 0,
})

function base_id_cap:allowed ( touch_entity )
	if phase ~= self.phase then
		return EVENT_DISALLOWED
	end	
	
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		
		for i,v in ipairs(self.item) do
			if player:HasItem( v ) then
				return EVENT_ALLOWED
			end
		end
	end
	
	return EVENT_DISALLOWED
end

function base_id_cap:oncapture(player, item)
	SmartSound(player, "yourteam.flagcap", "yourteam.flagcap", "otherteam.flagcap")
--SmartSound(player, "vox.yourcap", "vox.yourcap", "vox.enemycap")
	SmartSpeak(player, "CTF_YOUCAP", "CTF_TEAMCAP", "CTF_THEYCAP")
 	SmartMessage(player, "#FF_YOUCAP", "#FF_TEAMCAP", "#FF_OTHERTEAMCAP")

	local flag_item = GetInfoScriptByName( item )
	RemoveHudItem( player, flag_item:GetName() )

	-- turn off this flag
	for i,v in ipairs(self.item) do
		_G[v].enabled = nil
		local flag = GetInfoScriptByName(v)
		if flag then
			flag:Remove()
		end
	end

	if phase == NUM_PHASES then
		-- it's the last round. end and stuff
		AddSchedule("team_switch_delay", TEAM_SWITCH_DELAY, round_end)
	else
		phase = phase + 1

		-- enable the next flag after a time
		AddSchedule("flag_start", ROUND_DELAY, flag_start, self.next)
		if ROUND_DELAY > 30 then AddSchedule("flag_30secwarn", ROUND_DELAY-30, flag_30secwarn) end
		if ROUND_DELAY > 10 then AddSchedule("flag_10secwarn", ROUND_DELAY-10, flag_10secwarn) end		
		
		-- clear objective icon
		ATTACKERS_OBJECTIVE_ENTITY = nil
		UpdateTeamObjectiveIcon( GetTeam(attackers), nil )
		UpdateTeamObjectiveIcon( GetTeam(defenders), nil )
	end

end

function round_end()
		phase = 1

		if attackers == Team.kBlue then
			attackers = Team.kRed
			defenders = Team.kBlue
		else
			attackers = Team.kBlue
			defenders = Team.kRed
		end
		
		-- set all flag teams to new attackers
		flags_set_team( attackers )
		
		-- enable the first flag
		cp1_flag.enabled = true
		local flag = GetInfoScriptByName("cp1_flag")
		if flag then
			flag:Restore()
			flag:SetSkin(teamskins[attackers])
		end
		
		-- change objective icon
		ATTACKERS_OBJECTIVE_ENTITY = flag
		UpdateTeamObjectiveIcon( GetTeam(attackers), nil )
		UpdateTeamObjectiveIcon( GetTeam(defenders), nil )
		
		-- reset the timer on points
		AddScheduleRepeating("addpoints", PERIOD_TIME, addpoints)
		
		-- respawn the players
		RespawnAllPlayers()
		setup_door_timer("start_gate", INITIAL_ROUND_DELAY)
		
		-- run custom round reset stuff
		onroundreset()
end

function setup_door_timer(doorname, duration)
	CloseDoor(doorname)
	AddSchedule("round_start", duration, round_start, doorname)
	AddSchedule("round_30secwarn", duration-30, round_30secwarn)
	AddSchedule("round_10secwarn", duration-10, round_10secwarn)
end

function round_start(doorname)
	BroadCastMessage("Gates are now open!")
	OpenDoor(doorname)
end
function round_30secwarn() BroadCastMessage("30 Seconds until round starts") end
function round_10secwarn() BroadCastMessage("10 Seconds until round starts") end

function flag_start(flagname)
	BroadCastMessage("Flag is now at base!")
	_G[flagname].enabled = true
	local flag = GetInfoScriptByName(flagname)
	if flag then
		flag:Restore()
		flag:SetSkin(teamskins[attackers])
	end
	
	-- change objective icon
	ATTACKERS_OBJECTIVE_ENTITY = flag
	UpdateTeamObjectiveIcon( GetTeam(attackers), ATTACKERS_OBJECTIVE_ENTITY )
end
function flag_30secwarn() BroadCastMessage("30 Seconds until flag returns to base") end
function flag_10secwarn() BroadCastMessage("10 Seconds until flag returns to base") end

------------------------------------------------
-- instanciate them
------------------------------------------------
cp1_flag = base_id_flag:new({phase = 1})
cp2_flag = base_id_flag:new({phase = 2})
cp3_flag = base_id_flag:new({phase = 3})
cp4_flag = base_id_flag:new({phase = 4})
cp5_flag = base_id_flag:new({phase = 5})
cp6_flag = base_id_flag:new({phase = 6})
cp7_flag = base_id_flag:new({phase = 7})
cp8_flag = base_id_flag:new({phase = 8})
cp1_cap = base_id_cap:new({phase = 1, item = {"cp1_flag"}, next = "cp2_flag"})
cp2_cap = base_id_cap:new({phase = 2, item = {"cp2_flag"}, next = "cp3_flag"})
cp3_cap = base_id_cap:new({phase = 3, item = {"cp3_flag"}, next = "cp4_flag"})
cp4_cap = base_id_cap:new({phase = 4, item = {"cp4_flag"}, next = "cp5_flag"})
cp5_cap = base_id_cap:new({phase = 5, item = {"cp5_flag"}, next = "cp6_flag"})
cp6_cap = base_id_cap:new({phase = 6, item = {"cp6_flag"}, next = "cp7_flag"})
cp7_cap = base_id_cap:new({phase = 7, item = {"cp7_flag"}, next = "cp8_flag"})
cp8_cap = base_id_cap:new({phase = 8, item = {"cp8_flag"}, next = nil})

base_attacker_spawn = info_ff_teamspawn:new({ phase = 0, validspawn = function(self,player)
	return player:GetTeamId() == attackers and phase == self.phase
end })
base_defender_spawn = info_ff_teamspawn:new({ phase = 0, validspawn = function(self,player)
	return player:GetTeamId() == defenders and phase == self.phase
end })
cp1_attacker = base_attacker_spawn:new({phase=1})
cp2_attacker = base_attacker_spawn:new({phase=2})
cp3_attacker = base_attacker_spawn:new({phase=3})
cp4_attacker = base_attacker_spawn:new({phase=4})
cp5_attacker = base_attacker_spawn:new({phase=5})
cp6_attacker = base_attacker_spawn:new({phase=6})
cp7_attacker = base_attacker_spawn:new({phase=7})
cp8_attacker = base_attacker_spawn:new({phase=8})
cp1_defender = base_defender_spawn:new({phase=1})
cp2_defender = base_defender_spawn:new({phase=2})
cp3_defender = base_defender_spawn:new({phase=3})
cp4_defender = base_defender_spawn:new({phase=4})
cp5_defender = base_defender_spawn:new({phase=5})
cp6_defender = base_defender_spawn:new({phase=6})
cp7_defender = base_defender_spawn:new({phase=7})
cp8_defender = base_defender_spawn:new({phase=8})
