-----------------------------------------------------------------------------------------------------------------------------
-- INCLUDES
-----------------------------------------------------------------------------------------------------------------------------

IncludeScript("base_shutdown");
IncludeScript("base_location");

-----------------------------------------------------------------------------------------------------------------------------
-- LOCATIONS
-----------------------------------------------------------------------------------------------------------------------------

location_blue_flagroom	= location_info:new({ text = "Flag Room", team = Team.kBlue })
location_blue_window	= location_info:new({ text = "Security Window", team = Team.kBlue })
location_blue_security	= location_info:new({ text = "Security Area", team = Team.kBlue })
location_blue_courtyard	= location_info:new({ text = "Main Courtyard", team = Team.kBlue })
location_blue_rampside	= location_info:new({ text = "Ramp Side", team = Team.kBlue })
location_blue_secside	= location_info:new({ text = "Security Side", team = Team.kBlue })
location_blue_frontdoor	= location_info:new({ text = "Front Door", team = Team.kBlue })
location_blue_water		= location_info:new({ text = "Water Area", team = Team.kBlue })
location_blue_spawn		= location_info:new({ text = "Team Respawn", team = Team.kBlue })

location_red_flagroom	= location_info:new({ text = "Flag Room", team = Team.kRed })
location_red_window		= location_info:new({ text = "Security Window", team = Team.kRed })
location_red_security	= location_info:new({ text = "Security Area", team = Team.kRed })
location_red_courtyard	= location_info:new({ text = "Main Courtyard", team = Team.kRed })
location_red_rampside	= location_info:new({ text = "Ramp Side", team = Team.kRed })
location_red_secside	= location_info:new({ text = "Security Side", team = Team.kRed })
location_red_frontdoor	= location_info:new({ text = "Front Door", team = Team.kRed })
location_red_water		= location_info:new({ text = "Water Area", team = Team.kRed })
location_red_spawn		= location_info:new({ text = "Team Respawn", team = Team.kRed })

location_yard			= location_info:new({ text = "Yard", team = Team.kUnassigned })


-----------------------------------------------------------------------------
-- TOUCH RESUP
-- Brush volume which gives players health, ammo, etc...
-- Pretty much taken from ff_aardvark.lua
-----------------------------------------------------------------------------

touch_resup = trigger_ff_script:new({ team = Team.kUnassigned })

function touch_resup:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == self.team then
			player:AddHealth( 400 )
			player:AddArmor( 400 )
			player:AddAmmo( Ammo.kNails, 400 )
			player:AddAmmo( Ammo.kShells, 400 )
			player:AddAmmo( Ammo.kRockets, 400 )
			player:AddAmmo( Ammo.kCells, 400 )
		end
	end
end

blue_touch_resup = touch_resup:new({ team = Team.kBlue })
red_touch_resup = touch_resup:new({ team = Team.kRed })

-----------------------------------------------------------------------------------------------------------------------------
-- WINDOWPACK
-- Team-specific packs which are located near the window where players can throw the flag out.
-----------------------------------------------------------------------------------------------------------------------------

windowpack = genericbackpack:new({
	health = 50,
	armor = 50,
	
	nails = 0,
	shells = 100,
	rockets = 40,
	cells = 100,
	
	gren1 = 0,
	gren2 = 0,
	
	respawntime = 30,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	botgoaltype = Bot.kBackPack_Ammo
})
function windowpack:dropatspawn() return false end

blue_windowpack = windowpack:new({ touchflags = { AllowFlags.kOnlyPlayers, AllowFlags.kBlue } })
red_windowpack = windowpack:new({ touchflags = { AllowFlags.kOnlyPlayers, AllowFlags.kRed } })

-----------------------------------------------------------------------------
-- SPAWN PROTECTION
-- kills those who wander into the enemy spawn
-----------------------------------------------------------------------------

spawn_protection = trigger_ff_script:new({ team = Team.kUnassigned })

function spawn_protection:allowed( activator )
	local player = CastToPlayer( activator )
	if player then
		if player:GetTeamId() == self.team then
			return EVENT_ALLOWED
		end
	end
	return EVENT_DISALLOWED
end

red_spawn_protection = spawn_protection:new({ team = Team.kBlue })
blue_spawn_protection = spawn_protection:new({ team = Team.kRed })

-----------------------------------------------------------------------------
-- OFFENSIVE AND DEFENSIVE SPAWNS
-- Medic, Spy, and Scout spawn in the offensive spawns, other classes spawn in the defensive spawn,
-- Copied from ff_session.lua
-----------------------------------------------------------------------------

red_o_only = function(self,player) return ((player:GetTeamId() == Team.kRed) and ((player:GetClass() == Player.kScout) or (player:GetClass() == Player.kMedic) or (player:GetClass() == Player.kSpy))) end
red_d_only = function(self,player) return ((player:GetTeamId() == Team.kRed) and (((player:GetClass() == Player.kScout) == false) and ((player:GetClass() == Player.kMedic) == false) and ((player:GetClass() == Player.kSpy) == false))) end

red_ospawn = { validspawn = red_o_only }
red_dspawn = { validspawn = red_d_only }

blue_o_only = function(self,player) return ((player:GetTeamId() == Team.kBlue) and ((player:GetClass() == Player.kScout) or (player:GetClass() == Player.kMedic) or (player:GetClass() == Player.kSpy))) end
blue_d_only = function(self,player) return ((player:GetTeamId() == Team.kBlue) and (((player:GetClass() == Player.kScout) == false) and ((player:GetClass() == Player.kMedic) == false) and ((player:GetClass() == Player.kSpy) == false))) end

blue_ospawn = { validspawn = blue_o_only }
blue_dspawn = { validspawn = blue_d_only }
