
-- base_hunted.lua

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_teamplay");
IncludeScript("base_location");

-----------------------------------------------------------------------------
-- Basic hunted-style gameplay. Respawns all players when the VIP is killed
-----------------------------------------------------------------------------
POINTS_PER_HUNTED_DEATH = 10
POINTS_PER_HUNTED_DEATH_FOR_ASSASSIN = 10
POINTS_PER_HUNTED_ESCAPE = 10
POINTS_PER_HUNTED_ESCAPE_FOR_HUNTED = 10
POINTS_PER_HUNTED_ATTACK = 10
HUNTED_ALLIES_TEAM = Team.kRed

-- precache sounds
function precache()
	PrecacheSound("ff_hunted.thunder")
	PrecacheSound("ff_hunted.cheer")
	PrecacheSound("ff_hunted.dying_bird")
	PrecacheSound("ff_hunted.dying_bird_full")
	PrecacheSound("ff_hunted.dying_bird_full")
	PrecacheSound("ff_hunted.i_am_the_werewolf")
	PrecacheSound("ff_hunted.i_fight_vampires")
	PrecacheSound("ff_hunted.werewolf_howling")
	PrecacheSound("ff_hunted.werewolf_movies")
	PrecacheSound("ff_hunted.werewolves_howling")

	-- UNAGI POWER, UNAGI!
	PrecacheSound("ff_hunted.unagi")
end

function startup()

	-- set up team names
	SetTeamName( Team.kBlue, "The Hunted" )
	SetTeamName( Team.kRed, "Bodyguards" )
	SetTeamName( Team.kYellow, "Assassins" )
	SetTeamName( Team.kGreen, "Green Kid Touchers" )

	-- set up team limits
	SetPlayerLimit( Team.kBlue, 1 ) -- There can be only one Highlander!
	SetPlayerLimit( Team.kRed, 0 ) -- Unlimited bodyguards.
	SetPlayerLimit( Team.kYellow, 7 ) -- Only 7 assassins, but can we dynamically change this based on maxplayers and/or the current playercount?
	SetPlayerLimit( Team.kGreen, -1 ) -- Fuck green.

	local team = GetTeam( Team.kBlue )
	team:SetAllies( Team.kRed )
	team:SetClassLimit( Player.kScout, -1 )
	team:SetClassLimit( Player.kSniper, -1 )
	team:SetClassLimit( Player.kSoldier, -1 )
	team:SetClassLimit( Player.kDemoman, -1 )
	team:SetClassLimit( Player.kMedic, -1 )
	team:SetClassLimit( Player.kHwguy, -1 )
	team:SetClassLimit( Player.kPyro, -1 )
	team:SetClassLimit( Player.kSpy, -1 )
	team:SetClassLimit( Player.kEngineer, -1 )
	team:SetClassLimit( Player.kCivilian, 0 )

	team = GetTeam( Team.kRed )
	team:SetAllies( Team.kBlue )
	team:SetClassLimit( Player.kScout, -1 )
	team:SetClassLimit( Player.kSniper, 1 )
	team:SetClassLimit( Player.kSoldier, 0 )
	team:SetClassLimit( Player.kDemoman, 0 )
	team:SetClassLimit( Player.kMedic, 0 )
	team:SetClassLimit( Player.kHwguy, 0 )
	team:SetClassLimit( Player.kPyro, 0 )
	team:SetClassLimit( Player.kSpy, -1 )
	team:SetClassLimit( Player.kEngineer, 0 )
	team:SetClassLimit( Player.kCivilian, -1 )

	team = GetTeam( Team.kYellow )
	team:SetClassLimit( Player.kScout, -1 )
	team:SetClassLimit( Player.kSniper, 0 )
	team:SetClassLimit( Player.kSoldier, -1 )
	team:SetClassLimit( Player.kDemoman, -1 )
	team:SetClassLimit( Player.kMedic, -1 )
	team:SetClassLimit( Player.kHwguy, -1 )
	team:SetClassLimit( Player.kPyro, -1 )
	team:SetClassLimit( Player.kSpy, 1 )
	team:SetClassLimit( Player.kEngineer, -1 )
	team:SetClassLimit( Player.kCivilian, -1 )

end

function respawn_everyone()
	ApplyToAll({ AT.kRemovePacks, AT.kRemoveProjectiles, AT.kRespawnPlayers, AT.kRemoveBuildables, AT.kRemoveRagdolls, AT.kStopPrimedGrens })
end

function hunted_escape_notification()
	BroadCastMessage( "The Hunted escaped!" )
	BroadCastSound ( "ff_hunted.cheer" )
end

function player_ondamage( player, damageinfo )
	-- hunted has body armor on and only takes damage from a sniper rifle, knife, or crowbar
	if player:GetTeamId() == Team.kBlue then
		local weapon = damageinfo:GetInflictor():GetClassName()
		if weapon ~= "ff_weapon_sniperrifle" and weapon ~= "ff_weapon_crowbar" and weapon ~= "ff_projectile_dart" and weapon ~= "ff_weapon_knife" then
			damageinfo:ScaleDamage(0)
		else
			BroadCastSound ( "ff_hunted.dying_bird" )
		end
	-- hunted also has UNAGI POWER, UNAGI!
	else
		local attacker = damageinfo:GetAttacker()
		if IsPlayer( attacker ) then
			attacker = CastToPlayer( attacker )
			if attacker:GetTeamId() == Team.kBlue and player:GetTeamId() ~= HUNTED_ALLIES_TEAM then
				attacker:AddFortPoints( POINTS_PER_HUNTED_ATTACK * 10, "Hunted Attack" )
				damageinfo:ScaleDamage(69)
				ConsoleToAll( "The Hunted, " .. attacker:GetName() .. ", has UNAGI POWER, UNAGI!" )
				BroadCastSound ( "ff_hunted.unagi" )
			end
		end
	end
end

function player_onkill( player )
	-- Don't let blue hunted suicide.
	if player:GetTeamId() == Team.kBlue then
		return false
	end
	return true
end

function player_killed( player )
	-- We only care when The Hunted dies
	local player = CastToPlayer( player )

	if player:GetTeamId() == Team.kBlue then
		ConsoleToAll( "The Hunted, " .. player:GetName() .. ", was assassinated!" )
		BroadCastMessage( "The Hunted was assassinated!" )
		BroadCastSound ( "ff_hunted.werewolves_howling" )
		BroadCastSound ( "ff_hunted.thunder" )
		local team = GetTeam( Team.kYellow )
		team:AddScore( POINTS_PER_HUNTED_DEATH )
		AddSchedule("respawn_everyone", 2, respawn_everyone)
	end
end


BLOCKTEAMCHANGE = {}

function player_switchteam( player, currentteam, desiredteam )
	local i = player:GetId()
	local stime = GetServerTime()
	
	if desiredteam == Team.kBlue then
		local delaytime = BLOCKTEAMCHANGE[i]
		if delaytime ~= nil and delaytime > stime then
			return false
		end
		
		BLOCKTEAMCHANGE[i] = stime + 10;
	end
	return true
end

-- Give everyone a full resupply, but strip grenades from assassins
function player_spawn( player_entity )
	local player = CastToPlayer( player_entity )

	player:AddHealth( 100 )
	player:AddArmor( 100 )
	player:AddAmmo( Ammo.kNails, 300 )
	player:AddAmmo( Ammo.kShells, 300 )
	player:AddAmmo( Ammo.kRockets, 300 )
	player:AddAmmo( Ammo.kCells, 300 )
	player:AddAmmo( Ammo.kDetpack, 1 )
	player:AddAmmo( Ammo.kManCannon, 1 )
	player:AddAmmo( Ammo.kGren1, 4 )
	player:AddAmmo( Ammo.kGren2, 4 )

--	if player:GetTeamId() == Team.kRed then
--		BroadCastSoundToPlayer(player, "ff_hunted.i_fight_vampires")
--	elseif player:GetTeamId() == Team.kYellow then
--		BroadCastSoundToPlayer(player, "ff_hunted.werewolf_howling")
--	else
--		BroadCastSoundToPlayer(player, "ff_hunted.i_am_the_werewolf")
--	end
end


-- escape portal entrance
hunted_escape = trigger_ff_script:new({ })

-- escape touch
function hunted_escape:ontouch( touch_entity )

	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == Team.kBlue then
			player:AddFrags( POINTS_PER_HUNTED_ESCAPE_FOR_HUNTED )
			player:AddFortPoints( POINTS_PER_HUNTED_ESCAPE_FOR_HUNTED * 10, "Hunted Escape" )

			ConsoleToAll( "The Hunted, " .. player:GetName() .. ", escaped!" )
			BroadCastSound ( "ff_hunted.unagi" )

			local team = GetTeam( Team.kBlue )
			team:AddScore( POINTS_PER_HUNTED_ESCAPE )
			team = GetTeam( Team.kRed )
			team:AddScore( POINTS_PER_HUNTED_ESCAPE )

			ApplyToAll({ AT.kRemovePacks, AT.kRemoveProjectiles, AT.kRespawnPlayers, AT.kRemoveBuildables, AT.kRemoveRagdolls, AT.kStopPrimedGrens })

			AddSchedule("hunted_escape_notification", 0.1, hunted_escape_notification)
		end
	end

end

function EscapeDoor:OnOpen()
	
end

-- team specific doors
func_door = trigger_ff_script:new({})
function func_door:allowed( allowed_entity )
	if IsPlayer( allowed_entity ) then
		local player = CastToPlayer( allowed_entity )
		if player:GetTeamId() == self.team then 
			return EVENT_ALLOWED
		end
	end
	return EVENT_DISALLOWED
end
yellow_door = func_door:new({ team = Team.kYellow })
