
-- ff_monkey.lua

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_ctf")
IncludeScript("base_location")
IncludeScript("base_respawnturret")

-----------------------------------------------------------------------------
-- global overrides
-----------------------------------------------------------------------------
POINTS_PER_CAPTURE = 10
FLAG_RETURN_TIME = 60

function startup()
	-- set up team limits on each team
	SetPlayerLimit(Team.kBlue, 0)
	SetPlayerLimit(Team.kRed, 0)
	SetPlayerLimit(Team.kYellow, -1)
	SetPlayerLimit(Team.kGreen, -1)

	-- CTF maps generally don't have civilians,
	-- so override in map LUA file if you want 'em
	local team = GetTeam(Team.kBlue)
	team:SetClassLimit(Player.kCivilian, -1)

	team = GetTeam(Team.kRed)
	team:SetClassLimit(Player.kCivilian, -1)
end


-----------------------------------------------------------------------------
-- Pickups
-----------------------------------------------------------------------------

monkeypackgeneric = genericbackpack:new({
	health = 20,
	armor = 15,
	grenades = 60,
	nails = 60,
	shells = 60,
	rockets = 60,
	cells = 60,
	mancannons = 1,
	gren1 = 1,
	gren2 = 1,
	respawntime = 35,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	botgoaltype = Bot.kBackPack_Ammo
})

function monkeypackgeneric:dropatspawn() return false end

redmonkeypack = genericbackpack:new({
	health = 200,
	armor = 200,
	grenades = 90,
	nails = 90,
	shells = 90,
	rockets = 90,
	cells = 90,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kRed},
	botgoaltype = Bot.kBackPack_Ammo
})

function redmonkeypack:dropatspawn() return false end

redmonkeypacktoo = genericbackpack:new({
	health = 20,
	armor = 15,
	grenades = 10,
	nails = 30,
	shells = 30,
	rockets = 10,
	cells = 30,
	respawntime = 20,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kRed},
	botgoaltype = Bot.kBackPack_Ammo
})

function redmonkeypacktoo:dropatspawn() return false end

bluemonkeypack = genericbackpack:new({
	health = 200,
	armor = 200,
	grenades = 90,
	nails = 90,
	shells = 90,
	rockets = 90,
	cells = 90,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kBlue},
	botgoaltype = Bot.kBackPack_Ammo
})

function bluemonkeypack:dropatspawn() return false end

bluemonkeypacktoo = genericbackpack:new({
	health = 20,
	armor = 15,
	grenades = 10,
	nails = 30,
	shells = 30,
	rockets = 10,
	cells = 30,
	respawntime = 20,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kBlue},
	botgoaltype = Bot.kBackPack_Ammo
})

function bluemonkeypacktoo:dropatspawn() return false end

redmonkeygrenades = genericbackpack:new({
	detpacks = 1,
	mancannons = 1,
	gren1 = 4,
	gren2 = 4,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kRed},
	botgoaltype = Bot.kBackPack_Ammo
})

function redmonkeygrenades:dropatspawn() return false end

bluemonkeygrenades = genericbackpack:new({
	detpacks = 1,
	mancannons = 1,
	gren1 = 4,
	gren2 = 4,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kBlue},
	botgoaltype = Bot.kBackPack_Ammo
})

function bluemonkeygrenades:dropatspawn() return false end
-----------------------------------------------------------------------------
-- Locations
-----------------------------------------------------------------------------
location_blue_frupper = location_info:new({ text = "Flag Room Catwalks", team = Team.kBlue })
location_red_frupper = location_info:new({ text = "Flag Room Catwalks", team = Team.kRed })

location_blue_frlower = location_info:new({ text = "Lower Flag Room", team = Team.kBlue})
location_red_frlower = location_info:new({ text = "Lower Flag Room", team = Team.kRed })

location_blue_frwater = location_info:new({ text = "Flag Room Water", team = Team.kBlue })
location_red_frwater = location_info:new({ text = "Flag Room Water", team = Team.kRed })

location_blue_ladder = location_info:new({ text = "Battlements Ladder", team = Team.kBlue })
location_red_ladder = location_info:new({ text = "Battlements Ladder", team = Team.kRed })

location_blue_concexit = location_info:new({ text = "Conc Route Exit", team = Team.kBlue })
location_red_concexit = location_info:new({ text = "Conc Route Exit", team = Team.kRed })

location_blue_canal = location_info:new({ text = "Yard Canal", team = Team.kBlue })
location_red_canal = location_info:new({ text = "Yard Canal", team = Team.kRed })


-----------------------------------------------------------------------------
-- Doors
-----------------------------------------------------------------------------

