//=========== (C) Copyright 1999 Valve, L.L.C. All rights reserved. ===========
//
// The copyright to the contents herein is the property of Valve, L.L.C.
// The contents may be used and/or copied only with the written permission of
// Valve, L.L.C., or in accordance with the terms and conditions stipulated in
// the agreement/contract under which the contents have been supplied.
//=============================================================================

// No spaces in event names, max length 32
// All strings are case sensitive
//
// valid data key types are:
//   string : a zero terminated string
//   bool   : unsigned int, 1 bit
//   byte   : unsigned int, 8 bit
//   short  : signed int, 16 bit
//   long   : signed int, 32 bit
//   float  : float, 32 bit
//   local  : any data, but not networked to clients
//
// following key names are reserved:
//   local      : if set to 1, event is not networked to clients
//   unreliable : networked, but unreliable
//   suppress   : never fire this event
//   time	: firing server time
//   eventid	: holds the event ID

"esevents"
{
	"death_notice"
	{
		// this extents the original player_death by a new fields
		"victim"	"short"   	// ent index of the entity that died		
		"attacker"	"short"	 	// ent index of the attacker
		"weapon"	"string" 	// weapon name killer used 
	}

	"player_hurt"
	{
		"userid"	"short"   	// player index who was hurt
		"attacker"	"short"	 	// player index who attacked
		"health"	"byte"		// remaining health points
		"weapon"	"string"	// weapon name attacker used, if not the world
		"dmg_health"	"byte"	// damage done to health
		"dmg_armor"	"float"		// damage done to armor
		"hitgroup"	"byte"		// hitgroup that was damaged
	}
	
	"game_endmap"
	{
	}
	
	"capship_create"
	{
		"capid"		"short"
	}
	
	"capship_killed"
	{
		"capid"		"short"
		"teamid"	"byte" // Team that lost it
	}
	
	"phase_attackers"
	{
		"teamid" "byte" // Current Attackers
		"oldteamid" "byte" // Last Attackers
	}
	
	//	The "subsystem_" gameevents as of now need some
	//	standardization.  Thus, I'm "renormalizing" all
	//	the fields to the following if applicable:  (JS)
	
	//	"subid"		subsystem entity index
	//	"capid"		capship entity index
	//	"playerid"	player id of player who did it
	//	"teamid"	the above player's teamid
	
	"subsystem_capture"
	{
		"subid"		"short"
		"teamid"	"byte"
		"oldteamid" "byte"
	}
	"subsystem_secure"
	{
		"subid"		"short"
		"playerid"	"short"
		"teamid"	"byte"
	}
	"subsystem_attacked"
	{
		"subid"		"short"
		"teamid"	"byte"
	}
}
