init()
{
  // We're in the server init routine. Do stuff before the game starts.
  Precache();

  // The server may move on now so we thread the rest.
  thread SetupCvars();
  thread StartThreads();
}

PreCache()
{
  precacheShellShock("default");
  precacheShellshock("groggy");	
  level._effect["bombexplosion"] = loadfx("fx/props/barrelexp.efx"); 
  level._effect["b3burn"]	= loadfx("fx/fire/character_torso_fire.efx");	
}

SetupCvars()
{
	// Lets make sure were empty before we start the threads
	setcvar("b3_saybold", "");
  setcvar("b3_endmap", "");
  setcvar("b3_rcid", "");
	setcvar("b3_rname", "");
	setcvar("b3_shock", "");
	setcvar("b3_burn", "");
	setcvar("b3_explode", "");
	setcvar("b3_forceteamcid", "");
	setcvar("b3_forceteamname", "");
	setcvar("b3_scorecid", "");
	setcvar("b3_score", "");
	setcvar("b3_deathcid", "");
	setcvar("b3_death", "");
	setcvar("b3_compensate", "");
	setcvar("b3_losepoint", "");
	level.b3endmap = false;

}

StartThreads()
{
	wait .05;
	level endon("awe_killthreads");

  thread CvarChecker();

  // !EDIT!
  // Ravir's (also used in Bullet Worms Powerserver mod)
  // Comment the next 3 lines if you already have the admintools installed (eg. bullet-worms powerservermod)
  // Commenting is done by adding // to the beginning of each line.
  thread switchteam();
	thread killum();
	thread switchspec();

}

//------Threads and Functions---------------------------------------------------

// Communication between b3 and this mod depends on cvars/dvars.
// This is our major thread that checks our specific cvars/dvars changing
// Each command will clean up the leftovers on its own.
CvarChecker()
{
	level endon("awe_killthreads");

	while(1)
  {
    if ( getcvar( "b3_saybold" ) != "" )
      _b3_saybold();
    if ( ( getcvar( "b3_endmap" ) != "" ) || ( level.b3endmap == true ) )
      _b3_endmap();
    if( getcvar( "b3_rcid" ) != "" )
      thread _b3_renamer();
    if( getcvar( "b3_shock" ) != "" )
      thread _b3_shock();
    if( getcvar( "b3_burn" ) != "" )
      thread _b3_burn();
    if( getcvar( "b3_explode" ) != "" )
      thread _b3_explode();
    if( getcvar( "b3_scorecid" ) != "" )
      thread _b3_score();
    if( getcvar( "b3_forceteamcid" ) != "" )
      thread _b3_forceteam();
    if( getcvar( "b3_deathcid" ) != "" )
      thread _b3_death();
    if( getcvar( "b3_compensate" ) != "" )
      thread _b3_compensate();
    if( getcvar( "b3_losepoint" ) != "" )
      thread _b3_losepoint();
    wait .1;
  }
}


//Print a message on the center of the screen
_b3_saybold()
{
	msg  = getcvar("b3_saybold");
	setcvar("b3_saybold", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)			
		players[i] playLocalSound("ctf_touchown");	
	iprintlnbold(msg);
}


// End the map?
_b3_endmap()

// !EDIT!
// Make sure you remove/comment any gametypes that you do NOT have installed on your server.
{
  // If the command was given by an admin it must be in the cvar
	if(getcvar("b3_endmap") != "")
    {
    iprintlnbold("^1*** ^7Admin is ending the map! ^1***^7");
    wait 5;
    }
  setcvar("b3_endmap", "");

	// If we come from within the script we use level.b3endmap so we better reset it.
  level.b3endmap = false;
	
  currenttype = getcvar("g_gametype");
	level.mapended = true;
	
  if ( currenttype == "ctf" )
  {
    level thread maps\mp\gametypes\ctf::EndMap();
    return;
  }
  if ( currenttype == "dm" )
  {
    level thread maps\mp\gametypes\dm::EndMap();
    return;
  }
  if ( currenttype == "hq" )
  {
    level thread maps\mp\gametypes\hq::EndMap();
    return;
  }
  if ( currenttype == "sd" )
  {
    level thread maps\mp\gametypes\sd::EndMap();
    return;
  }
  if ( currenttype == "tdm" )
  {
    level thread maps\mp\gametypes\tdm::EndMap();
    return;
  }


	maps\mp\_utility::error("Unsupported Gametype");
	//Since we're still here, we need to end the map. Let's take a shortcut.
	endMapSafety();
}

endMapSafety()
{
	game["state"] = "intermission";
	level notify("intermission");

	exitLevel(false);
}

// Force a player to a team
_b3_forceteam()
{
	forcePlayerNum = getcvarint("b3_forceteamcid");
	moveToTeam = getcvar("b3_forceteamname");
	setcvar("b3_forceteamcid", "");
	setcvar("b3_forceteamname", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];

		thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == forcePlayerNum) // this is the one we're looking for
		{

      if(player.pers["team"] == moveToTeam)
        return;

      if(moveToTeam == "allies")
				newTeam = "allies";
			else if(moveToTeam == "axis")
				newTeam = "axis";
			else
        return;

			if(isAlive(player))
			{
				
        player unlink();
				player suicide();

        player.deaths--;
			}

			player.pers["team"] = newTeam;
			player.pers["weapon"] = undefined;
			player.pers["weapon1"] = undefined;
			player.pers["weapon2"] = undefined;
			player.pers["spawnweapon"] = undefined;
			player.pers["savedmodel"] = undefined;
			player.pers["secondary_weapon"] = undefined;

			player setClientCvar("ui_allow_weaponchange", "1");

			if(newTeam == "allies")
			{
				player openMenu(game["menu_weapon_allies"]);
				scriptMainMenu = game["menu_weapon_allies"];
			}
			else
			{
				player openMenu(game["menu_weapon_axis"]);
				scriptMainMenu = game["menu_weapon_axis"];
			}
		}
	}
}

// Alter a players scorepoints
_b3_score()
{
	forcePlayerNum = getcvarint("b3_scorecid");
	forceScoreDiff = getcvarint("b3_score");
	setcvar("b3_scorecid", "");
	setcvar("b3_score", "");

	if(forceScoreDiff == 0)
    return;

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];

		thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == forcePlayerNum) // this is the one we're looking for
		{

        newscore = player.score + forceScoreDiff;
        player.score = newscore;

				if(forceScoreDiff < 0)
				  iprintln(player.name + "^7's score was reduced:  " + forceScoreDiff + " by the admin");
				if(forceScoreDiff > 0)
				  iprintln(player.name + "^7's score was increased:  " + forceScoreDiff + " by the admin");
		}
	}
}

// ALter a players deathcount
_b3_death()
{
	forcePlayerNum = getcvarint("b3_deathcid");
	forceDeathDiff = getcvarint("b3_death");
	setcvar("b3_deathcid", "");
	setcvar("b3_death", "");

	if(forceDeathDiff == 0)
    return;

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];

		thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == forcePlayerNum) // this is the one we're looking for
		{

        newdeaths = player.deaths + forceDeathDiff;
        player.deaths = newdeaths;

				if(forceDeathDiff < 0)
				  iprintln(player.name + "^7's deathcount was reduced:  " + forceDeathDiff + " by the admin");
				if(forceDeathDiff > 0)
				  iprintln(player.name + "^7's deathcount was increased:  " + forceDeathDiff + " by the admin");
		}
	}
}

// Compensate a player: score +1 and deaths -1
_b3_compensate()
{
	forcePlayerNum = getcvarint("b3_compensate");
	setcvar("b3_compensate", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];

		thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == forcePlayerNum) // this is the one we're looking for
		{
        player.score++;
        player.deaths--;

			  iprintln(player.name + "^7 was compensated by the admin (Score +1 // Deaths -1)");
		}
	}
}

// Make a player lose a point
_b3_losepoint()
{
	forcePlayerNum = getcvarint("b3_losepoint");
	setcvar("b3_losepoint", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];

		thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == forcePlayerNum) // this is the one we're looking for
		{
        player.score--;

			  iprintln(player.name + "^7 lost a scorepoint!");
		}
	}
	setcvar("b3_losepoint", "");
}


// The B3 !rename command:
_b3_renamer()
{
	B3PlayerNum = getcvarint("b3_rcid");
	B3CvarValue = getcvar("b3_rname");
	setcvar("b3_rcid", "");
	setcvar("b3_rname", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];
		
    thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == B3PlayerNum) // this is the one we're looking for
		{
			player unlink();
			player setClientCvar("name", B3CvarValue);
		}
	}
}


//------PUNISHMENTS-------------------------------------------------------------

// The B3 !pashock command:
_b3_shock()
{
	B3PlayerNum = getcvarint("b3_shock");
  B3CvarValue = getcvarint("b3_shocktime");
	setcvar("b3_shocktime", "");
	setcvar("b3_shock", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];
		
    thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == B3PlayerNum) // this is the one we're looking for
		{
			player thread _cmd_shock_threaded(B3CvarValue);
		}
	}
	return;
}
_cmd_shock_threaded(time)
{	
  if (time)
    self shellshock("default", time);
  else
    self shellshock("default", 7);
 	iprintln(self.name + "^7 just had a SHOCKING experience!");		
	return;
}


//Light players on fire
_b3_burn()
{
	B3PlayerNum = getcvarint("b3_burn");
	setcvar("b3_burn", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];
		
    thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == B3PlayerNum) // this is the one we're looking for
		{
			player thread _cmd_burn_threaded();
		}
	}
}
_cmd_burn_threaded()
{	
	if (self.pers["team"] != "spectator")
	{
		if(isAlive(self))
		{
    	self.burnedout = false;
    	self thread _cmd_burn_damage();
    	self thread _cmd_burn_breath();
    	iprintln(self.name + "^7 is on FIRE!");		
    	while(self.burnedout == false)
    	{			
    		playfx(level._effect["b3burn"], self.origin);
        wait .1;	
    	}
	  } 
  }
  return;
}
//Do heavy breathing while burning
_cmd_burn_breath()
{
  while(self.burnedout == false)
  {
    self playLocalSound("breathing_hurt");
    wait 1;
  }
  return;
}
//Do the burn damage and sounds, kill player after 10 seconds
_cmd_burn_damage()
{
  wait 5;
  self shellshock("groggy", 5);
  wait 5;
 	self suicide();
 	self.burnedout = true;

  return;
}


//Blow the player up
_b3_explode()
{
	B3PlayerNum = getcvarint("b3_explode");
	setcvar("b3_explode", "");

	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];
		
    thisPlayerNum = player getEntityNumber();
		if(thisPlayerNum == B3PlayerNum) // this is the one we're looking for
		{
			player thread _cmd_explode_threaded();
		}
	}
}
_cmd_explode_threaded()
{	
	if (self.pers["team"] != "spectator")
	{
		if(isAlive(self))
		{
      playfx(level._effect["bombexplosion"], self.origin);
      self playSound("mortar_explosion" + (randomInt(5) + 1));
    	wait .05;
    	self suicide();
    	iprintln(self.name + "^7 was blown to bits!");		
	  } 
  }
  return;
}


//------ORIGINAL-CODE-BY-RAVIR-AND-BULLET-WORM-MODIFIED-BY-XLR8OR---------------

switchteam()
{
	level endon("awe_killthreads");
	newTeam = undefined;
	setcvar("g_switchteam", "");
	while(1)
	{
		if(getcvar("g_switchteam") != "")
		{
			if (getcvar("g_switchteam") == "all")
				setcvar("g_switchteam", "-1");

			movePlayerNum = getcvarint("g_switchteam");
			players = getentarray("player", "classname");
			for(i = 0; i < players.size; i++)
			{
				player = players[i];

				thisPlayerNum = player getEntityNumber();
				if(thisPlayerNum == movePlayerNum || movePlayerNum == -1) // this is the one we're looking for
				{

					if(player.pers["team"] == "axis")
						newTeam = "allies";
					if(player.pers["team"] == "allies")
						newTeam = "axis";

					if(isAlive(player))
					{
						player unlink();
						player suicide();

            player.deaths--;
					}

					player.pers["team"] = newTeam;
					player.pers["weapon"] = undefined;
					player.pers["weapon1"] = undefined;
					player.pers["weapon2"] = undefined;
					player.pers["spawnweapon"] = undefined;
					player.pers["savedmodel"] = undefined;
					player.pers["secondary_weapon"] = undefined;

					player setClientCvar("ui_allow_weaponchange", "1");

					if(newTeam == "allies")
					{
						player openMenu(game["menu_weapon_allies"]);
						scriptMainMenu = game["menu_weapon_allies"];
					}
					else
					{
						player openMenu(game["menu_weapon_axis"]);
						scriptMainMenu = game["menu_weapon_axis"];
					}
					if(movePlayerNum != -1)
						iprintln(player.name + "^7 was forced to switch teams by the admin");
				}
			}
			if(movePlayerNum == -1)
				iprintln("The admin forced all players to switch teams.");

			setcvar("g_switchteam", "");
		}
		wait 0.05;
	}
}

killum()
{
	level endon("awe_killthreads");

	setcvar("g_killplayer", "");
	while(1)
	{
		if(getcvar("g_killplayer") != "")
		{
			killPlayerNum = getcvarint("g_killplayer");
			players = getentarray("player", "classname");
			for(i = 0; i < players.size; i++)
			{
				thisPlayerNum = players[i] getEntityNumber();
				if(thisPlayerNum == killPlayerNum && isAlive(players[i]) ) // this is the one we're looking for
				{
					players[i] unlink();
					players[i] suicide();
					iprintln(players[i].name + "^7 was killed by the admin");
				}
			}
			setcvar("g_killplayer", "");
		}
		wait 0.05;
	}
}

switchspec()
{
	level endon("awe_killthreads");
	setcvar("g_switchspec", "");
	while(1)
	{
		if(getcvar("g_switchspec") != "")
		{
			if (getcvar("g_switchspec") == "all")
				setcvar("g_switchspec", "-1");

			movePlayerNum = getcvarint("g_switchspec");
			players = getentarray("player", "classname");
			for(i = 0; i < players.size; i++)
			{
				thisPlayerNum = players[i] getEntityNumber();
				if(thisPlayerNum == movePlayerNum || movePlayerNum == -1) // this is the one we're looking for
				{
					player = players[i];

					if(isAlive(player))
					{

						player unlink();
						player suicide();

						player.switching_teams = true;
						player.joining_team = "spectator";
						player.leaving_team = player.pers["team"];

            /*
            player.deaths--;
  		      */

						wait 2;
					}
						
					player.pers["team"] = "spectator";
					player.pers["teamTime"] = 1000000;
					player.pers["weapon"] = undefined;
					player.pers["weapon1"] = undefined;
					player.pers["weapon2"] = undefined;
					player.pers["spawnweapon"] = undefined;
					player.pers["savedmodel"] = undefined;
					player.pers["secondary_weapon"] = undefined;
					
					player.sessionteam = "spectator";
					player.sessionstate = "spectator";
					player.spectatorclient = -1;
					player.archivetime = 0;
					player.friendlydamage = undefined;
					player setClientCvar("g_scriptMainMenu", game["menu_team"]);
					player setClientCvar("ui_weapontab", "0");
					player.statusicon = "";
					
					player notify("spawned");
					player notify("end_respawn");
					resettimeout();

					player thread maps\mp\gametypes\_spectating::setSpectatePermissions();

					spawnpointname = "mp_teamdeathmatch_intermission";
					spawnpoints = getentarray(spawnpointname, "classname");
					spawnpoint = maps\mp\gametypes\_spawnlogic::getSpawnpoint_Random(spawnpoints);
	
					if(isDefined(spawnpoint))
						player spawn(spawnpoint.origin, spawnpoint.angles);
					else
						maps\mp\_utility::error("NO " + spawnpointname + " SPAWNPOINTS IN MAP");

					if(movePlayerNum != -1)
            iprintln(player.name + "^7 was forced to Spectate by the admin");
					self notify("joined_spectators");
				}
			}

			if(movePlayerNum == -1)
				iprintln("The admin forced all players to Spectate.");

			setcvar("g_switchspec", "");
		}
		wait 0.05;
	}
}



