init()
{
  // We're in the server init routine. Do stuff before the game starts.
  Precache();

  // The server may move on now so we thread the rest.
  thread SetupCvars();
  thread StartThreads();
}

PreCache()
{
  //
}

SetupCvars()
{
  if (getcvar("b3_music") == "")
    setcvar("b3_music", "1");
  level.b3_music = getcvarint("b3_music");

  if (getcvar("b3_music") == "")
    setcvar("b3_deathmusic", "1");
  level.b3_deathmusic = getcvarint("b3_deathmusic");

  if (getcvar("b3_music") == "")
    setcvar("b3_specmusic", "1");
  level.b3_specmusic = getcvarint("b3_specmusic");
  
  if (getcvar("awe_map_vote_time") == "")
    level.b3_wait_time = 0;
  else
    level.b3_wait_time = getcvarint("awe_map_vote_time");
}

StartThreads()
{
  wait .1;
	if (level.b3_music == 0)
		return;

  level endon("awe_killthreads");

  thread onIntermission();
  thread onPlayerConnect();
}

//------Threads and Functions---------------------------------------------------
onIntermission()
{
  level endon("awe_killthreads");

  while(1)
  {
    if(level.mapended)
    {
      level thread endingmusic();
    }
    wait .5;
  }
}

onPlayerConnect()
{
  level endon("awe_killthreads");

  for(;;)
  {
    level waittill("connecting", player);
    
    if(level.b3_debug == true)
      iprintln("Debug (MUS): Player Connected...");
    
    player thread onPlayerSpawned();
    
    if(level.b3_deathmusic == 1)
      player thread onPlayerKilled();
    
    if(level.b3_specmusic == 1)
      player thread onPlayerJoinedSpec();
    
    player thread stopmusic();
  }
}

onPlayerSpawned()
{
  self endon("disconnect");

  for(;;)
  {
    self waittill("spawned_player");
    
    if(level.b3_debug == true)
      iprintln("Debug (MUS): Player Spawned...");

    // Kill Local music
    self playLocalSound("spec_music_null");
  }
}

onPlayerKilled()
{
  self endon("disconnect");

  for(;;)
  {
    self waittill("killed_player");
    
    if(level.b3_debug == true)
      iprintln("Debug (MUS): Player Killed...");

    //self.pers["deathmusic_on"] = true;
    self thread deathmusic();
  }
}


onPlayerJoinedSpec()
{
  self endon("disconnect");

  for(;;)
  {
    self waittill("joined_spectators");
    
    if(level.b3_debug == true)
      iprintln("Debug (MUS): Joined Spectators...");

    //self.pers["specmusic_on"] = true;
    self thread specmusic();
  }
}

stopmusic()
{
  level endon("awe_killthreads");

  while(1)
  {
    if(level.mapended)
    {
      self playLocalSound("spec_music_null");
    }
    wait .5;
  }
}

endingmusic()
{
  if(level.b3_debug == true)
    iprintln("Debug (MUS): Starting Ending Music...");

  musictime = level.b3_wait_time + 12;
  musicplay("ending_music");
  wait musictime;
  musicstop(3);
}

deathmusic()
{
  self playLocalSound("death_music");
}

specmusic()
{
  self playLocalSound("spec_music");
}
