/* 
  TinyUZ2 - UZ2 (de)Compression Utility
  version 1.2.1, February 28, 2005

  Copyright (C) 2004, 2005 Michiel Hendriks

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Michiel Hendriks - elmuerte@drunksnipers.com
*/

#ifndef __TINYUZ2_H
#define __TINYUZ2_H

#include "stdio.h"
#include "zlib.h"

#ifdef GNU
#define PATHDELIM '/'
#endif

#ifdef WIN32
#define PATHDELIM '\\'

#include <malloc.h>
#include <string.h>
#endif

#ifdef __ISN_IBO
// is not intel byte order
#define BOS_LONG(Var) SwapLong(Var)
#define BOS_LONG_S(Var) Var = SwapLong(Var);

static inline long SwapLong (long addr)
{
  return (addr >> 24 & 0xFF) | (addr >> 8 & 0xFF00) | (addr << 8 & 0xFF0000) |
    (addr << 24 & 0xFF000000);
}

#else
#define BOS_LONG(Var) Var
#define BOS_LONG_S(Var)
#endif

char *basename (char *path);
int compressFile ();
int uncompressFile ();
int showDecompressInfo (char *uname, FILE * ufile);
int showInfo (char *uname, FILE * ufile);

#endif
